/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.domain.riskassessors;

import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class TaskFlagRiskAssessor
extends RiskAssessor {
    @Property(description="Minimum amount of flags to have to score")
    protected int minFlags;
    @Property(description="Maximum amount of flags to have to score")
    protected int maxFlags;

    protected RiskAssessment executeForFlag(RiskAssessment assessment, Release release, RiskProfile riskProfile, FlagStatus flagStatus, String flaggedHeadline) {
        List<Task> flaggedTasks = release.getAllTasks().stream().filter(t -> flagStatus == t.getFlagStatus()).collect(Collectors.toList());
        ArrayList<String> messages = new ArrayList<String>();
        int numberOfFlaggedTasks = flaggedTasks.size();
        if (numberOfFlaggedTasks == 0) {
            assessment.setScore(0);
            assessment.setHeadline("Release is on track");
        } else {
            int score = this.getScore(numberOfFlaggedTasks, riskProfile);
            if (score != 0) {
                assessment.setHeadline(flaggedHeadline);
                flaggedTasks.forEach(t -> messages.add(String.format("%s: %s", t.getTitle(), Optional.ofNullable(t.getFlagComment()).orElse(""))));
                assessment.setScore(this.getScore(numberOfFlaggedTasks, riskProfile));
            } else {
                assessment.setScore(0);
                assessment.setHeadline("Release is on track");
            }
        }
        assessment.setMessages(messages);
        return assessment;
    }

    protected abstract int getScore(int var1, RiskProfile var2);

    public int getMinFlags() {
        return this.minFlags;
    }

    public void setMinFlags(int minFlags) {
        this.minFlags = minFlags;
    }

    public int getMaxFlags() {
        return this.maxFlags;
    }

    public void setMaxFlags(int maxFlags) {
        this.maxFlags = maxFlags;
    }
}

