/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.versioning.ascode.validation;

import com.xebialabs.xlrelease.domain.versioning.ascode.CiInfo;
import com.xebialabs.xlrelease.domain.versioning.ascode.validation.HardcodedPassword;
import com.xebialabs.xlrelease.domain.versioning.ascode.validation.MissingPassword;
import com.xebialabs.xlrelease.domain.versioning.ascode.validation.NonVersionedRef;

public interface ValidationMessage {
    public static final String LEVEL_ERROR = "ERROR";
    public static final String LEVEL_WARN = "WARNING";

    public CiInfo getCi();

    public String getProperty();

    public String getMessage();

    public String getMessageType();

    public String getMessageLevel();

    public static ValidationMessage updateCiId(ValidationMessage msg, String id) {
        if (msg instanceof HardcodedPassword) {
            HardcodedPassword hp = (HardcodedPassword)msg;
            return new HardcodedPassword(hp.getCi().withCiId(id), hp.getProperty());
        }
        if (msg instanceof MissingPassword) {
            MissingPassword mp = (MissingPassword)msg;
            return new MissingPassword(mp.getCi().withCiId(id), mp.getProperty(), mp.getPlaceholder());
        }
        if (msg instanceof NonVersionedRef) {
            NonVersionedRef nv = (NonVersionedRef)msg;
            return new NonVersionedRef(nv.getCi().withCiId(id), nv.getProperty(), nv.getRef());
        }
        throw new IllegalArgumentException("Unknown ValidationMessage type: " + String.valueOf(msg.getClass()));
    }
}

