/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.configuration;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.BaseSettings;

@Metadata(root=Metadata.ConfigurationItemRoot.CONFIGURATION, versioned=false, label="Audit reports", description="Release will use these settings to manage the lifecycle and data available to Audit reports.")
public class AuditReportSettings
extends BaseSettings {
    public static final String AUDIT_REPORT_SETTINGS_ID = "Configuration/settings/AuditReportSettings";
    @Property(defaultValue="calendar", hidden=true)
    private String displayIcon;
    @Property(defaultValue="reports-settings", hidden=true)
    private String displayPage;
    @Property(defaultValue="concept/release-audit-report", hidden=true)
    private String documentationPage;
    @Property(defaultValue="0", hidden=true)
    private Integer weight;
    @Property(defaultValue="10", required=false, label="Delete Release Audit reports older than", description="Release will use this setting to delete release audit reports that have been generated on the server. After deletion, release audit reports can no longer be downloaded.")
    private Integer reportsRetentionPeriod;
    @Property(label="Record historical changes in folder and global permissions", description="Each data change will trigger the storage of full membership and permission details for inclusion in the Audit report's Permissions sheet. Please note that enabling this feature may lead to significant increase in database size.", category="input", defaultValue="false")
    private boolean generatePermissionSnapshots = false;

    public void validate() {
        Preconditions.checkArgument((this.reportsRetentionPeriod > 0 ? 1 : 0) != 0, (Object)"Audit report retention period must be greater than 0 days.");
    }

    public Integer getReportsRetentionPeriod() {
        return this.reportsRetentionPeriod;
    }

    public void setReportsRetentionPeriod(Integer reportsRetentionPeriod) {
        this.reportsRetentionPeriod = reportsRetentionPeriod;
    }

    public boolean isGeneratePermissionSnapshots() {
        return this.generatePermissionSnapshots;
    }

    public void setGeneratePermissionSnapshots(boolean generatePermissionSnapshots) {
        this.generatePermissionSnapshots = generatePermissionSnapshots;
    }
}

