/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.delivery;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.internal.InternalMetadata;
import com.xebialabs.xlrelease.domain.CiWithInternalMetadata;
import com.xebialabs.xlrelease.domain.TenantAwareCi;
import com.xebialabs.xlrelease.domain.delivery.DeliveryStatus;
import com.xebialabs.xlrelease.domain.delivery.Stage;
import com.xebialabs.xlrelease.domain.delivery.Subscriber;
import com.xebialabs.xlrelease.domain.delivery.TrackedItem;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(root=Metadata.ConfigurationItemRoot.BY_ROOT_NAME, rootName="Deliveries", versioned=false)
public class Delivery
extends BaseConfigurationItem
implements CiWithInternalMetadata,
TenantAwareCi {
    public static final String DELIVERY_ROOT = "Deliveries";
    private String tenantId;
    private Map<String, InternalMetadata> $metadata = new LinkedHashMap<String, InternalMetadata>();
    @Property(description="Symbolic name for the release delivery.")
    private String title;
    @Property(required=false, description="Description for the delivery pattern.")
    private String description;
    @Property(description="The state the release delivery is in.")
    private DeliveryStatus status = DeliveryStatus.IN_PROGRESS;
    @Property(required=false, description="The expected start date.")
    private Date startDate;
    @Property(required=false, description="The expected end date.")
    private Date endDate;
    @Property(required=false, description="The time that the release delivery is supposed to take to complete, in hours.")
    private Integer plannedDuration = 0;
    @Property(required=false, description="List of releases contained by this release delivery.")
    private Set<String> releaseIds = new HashSet<String>();
    @Property(required=false, isTransient=true, description="Folder that the release delivery belongs to.")
    private String folderId;
    @Property(required=false, description="The ID of the pattern that created this delivery.")
    private String originPatternId;
    @Property(asContainment=true)
    private List<Stage> stages = new ArrayList<Stage>();
    @Property(asContainment=true)
    private List<TrackedItem> trackedItems = new ArrayList<TrackedItem>();
    @Property(asContainment=true)
    private List<Subscriber> subscribers = new ArrayList<Subscriber>();
    @Property(required=false, description="Complete delivery when all items are completed, skipped or de-scoped in all stages")
    private boolean autoComplete;

    public boolean isTemplate() {
        return this.status != null && this.status.isTemplate();
    }

    public void updateDuration() {
        LocalDateTime localScheduledStartDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(this.startDate.getTime()), ZoneId.systemDefault());
        LocalDateTime localDueDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(this.endDate.getTime()), ZoneId.systemDefault());
        int newDuration = Math.toIntExact(localScheduledStartDate.until(localDueDate, ChronoUnit.HOURS));
        this.setPlannedDuration(newDuration);
    }

    public Optional<TrackedItem> findItemByIdOrTitle(String idOrTitle) {
        return this.getTrackedItems().stream().filter(item -> Ids.getName((String)item.getId()).equals(Ids.getName((String)idOrTitle)) || item.getTitle().equalsIgnoreCase(idOrTitle)).findFirst();
    }

    public TrackedItem getItemByIdOrTitle(String idOrTitle) {
        return this.findItemByIdOrTitle(idOrTitle).orElseThrow(() -> new LogFriendlyNotFoundException("Tracked item '%s' does not exist in delivery '%s'", new Object[]{idOrTitle, this.title}));
    }

    public void addStage(Stage stage) {
        this.addStage(stage, this.stages.size());
    }

    public void addStage(Stage stage, int position) {
        this.stages.add(position, stage);
    }

    public void removeStage(Stage stage) {
        this.stages.remove((Object)stage);
    }

    public boolean isLastStage(Stage stage) {
        return this.getStages().indexOf((Object)stage) == this.getStages().size() - 1;
    }

    public Optional<Stage> findFirstOpenStage() {
        return this.getStages().stream().filter(Stage::isOpen).findFirst();
    }

    public Optional<Stage> findPreviousStage(Stage stage) {
        int index = this.getStages().indexOf((Object)stage);
        if (index <= 0) {
            return Optional.empty();
        }
        return Optional.of(this.getStages().get(index - 1));
    }

    public Optional<Stage> findNextStage(Stage stage) {
        int index = this.getStages().indexOf((Object)stage);
        if (index < 0 || index + 1 == this.getStages().size()) {
            return Optional.empty();
        }
        return Optional.of(this.getStages().get(index + 1));
    }

    public Optional<Stage> findStageByIdOrTitle(String idOrTitle) {
        String idName = Ids.getName((String)idOrTitle);
        return this.getStages().stream().filter(stage -> Ids.getName((String)stage.getId()).equals(idName) || stage.getTitle().equalsIgnoreCase(idOrTitle)).findFirst();
    }

    public Stage getStageByIdOrTitle(String idOrTitle) {
        return this.findStageByIdOrTitle(idOrTitle).orElseThrow(() -> new LogFriendlyNotFoundException("Stage '%s' does not exist in delivery '%s'", new Object[]{idOrTitle, this.title}));
    }

    @PublicApiMember
    public List<Transition> getTransitions() {
        return this.stages.stream().filter(stage -> stage.getTransition() != null).map(Stage::getTransition).collect(Collectors.toList());
    }

    public Optional<Transition> findTransitionByIdOrTitle(String transitionIdOrTitle) {
        return this.stages.stream().filter(s -> s.getTransition() != null && (Ids.getName((String)s.getTransition().getId()).equals(Ids.getName((String)transitionIdOrTitle)) || s.getTransition().getTitle().equals(transitionIdOrTitle))).map(Stage::getTransition).findFirst();
    }

    public Transition getTransitionByIdOrTitle(String transitionIdOrTitle) {
        return this.findTransitionByIdOrTitle(transitionIdOrTitle).orElseThrow(() -> new LogFriendlyNotFoundException("Transition '%s' does not exist in delivery '%s'", new Object[]{transitionIdOrTitle, this.title}));
    }

    public Stage getStageByTransition(Transition transition) {
        return this.getStageByTransitionId(transition.getId());
    }

    public Stage getStageByTransitionId(String transitionId) {
        Transition transition = this.getTransitionByIdOrTitle(transitionId);
        return transition.getStage();
    }

    public List<Stage> getStagesBeforeFirstOpenTransition() {
        ArrayList<Stage> stagesBefore = new ArrayList<Stage>();
        for (Stage stage : this.getStages()) {
            stagesBefore.add(stage);
            if (!stage.isOpen() || stage.getTransition() == null) continue;
            break;
        }
        return stagesBefore;
    }

    public List<Stage> getStagesBefore(Stage stage) {
        return this.stages.subList(0, this.stages.indexOf((Object)stage));
    }

    public List<Stage> getStageGroupAfterTransition(Transition transition) {
        ArrayList<Stage> stageGroup = new ArrayList<Stage>();
        Stage transitionStage = this.getStageByTransition(transition);
        int idx = this.stages.indexOf((Object)transitionStage);
        if (idx != -1) {
            ++idx;
            while (idx < this.stages.size()) {
                Stage s = this.stages.get(idx);
                stageGroup.add(s);
                if (s.getTransition() != null) break;
                ++idx;
            }
        }
        return stageGroup;
    }

    public List<Stage> getStageGroupOfStage(Stage stage) {
        ArrayList<Stage> stageGroup = new ArrayList<Stage>();
        int index = this.stages.indexOf((Object)stage);
        if (index != -1) {
            Stage s;
            ArrayList<Stage> leftList = new ArrayList<Stage>();
            for (int lidx = index - 1; lidx >= 0 && (s = this.stages.get(lidx)).getTransition() == null; --lidx) {
                leftList.add(s);
            }
            ArrayList<Stage> rightList = new ArrayList<Stage>();
            for (int ridx = index; ridx < this.stages.size(); ++ridx) {
                Stage s2 = this.stages.get(ridx);
                rightList.add(s2);
                if (s2.getTransition() != null) break;
            }
            Collections.reverse(leftList);
            stageGroup.addAll(leftList);
            stageGroup.addAll(rightList);
        }
        return stageGroup;
    }

    public <T extends Subscriber> List<T> getSubscribersOfType(Class<T> subscriberClass) {
        return this.getSubscribers().stream().filter(subscriber -> subscriber.getType().instanceOf(Type.valueOf((Class)subscriberClass))).map(subscriberClass::cast).collect(Collectors.toList());
    }

    public void addSubscriber(Subscriber subscriber) {
        this.subscribers.add(subscriber);
    }

    @PublicApiMember
    public Optional<Subscriber> findSubscriberBySourceId(String sourceId) {
        return this.getSubscribers().stream().filter(subscriber -> subscriber.getSourceId().equals(sourceId)).findFirst();
    }

    @PublicApiMember
    public String getTitle() {
        return this.title;
    }

    @PublicApiMember
    public void setTitle(String title) {
        this.title = title;
    }

    @PublicApiMember
    public String getDescription() {
        return this.description;
    }

    @PublicApiMember
    public void setDescription(String description) {
        this.description = description;
    }

    @PublicApiMember
    public DeliveryStatus getStatus() {
        return this.status;
    }

    @PublicApiMember
    public void setStatus(DeliveryStatus status) {
        this.status = status;
    }

    @PublicApiMember
    public Date getStartDate() {
        return this.startDate;
    }

    @PublicApiMember
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @PublicApiMember
    public Date getEndDate() {
        return this.endDate;
    }

    @PublicApiMember
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @PublicApiMember
    public Set<String> getReleaseIds() {
        return this.releaseIds;
    }

    @PublicApiMember
    public void setReleaseIds(Set<String> releaseIds) {
        this.releaseIds = releaseIds;
    }

    public void removeReleaseIds(List<String> idsToRemove) {
        List strippedIds = idsToRemove.stream().map(Ids::getName).collect(Collectors.toList());
        this.releaseIds = this.releaseIds.stream().filter(id -> !strippedIds.contains(Ids.getName((String)id))).collect(Collectors.toSet());
    }

    public boolean isUpdatable() {
        return !DeliveryStatus.COMPLETED.equals((Object)this.status);
    }

    @PublicApiMember
    public String getFolderId() {
        return this.folderId;
    }

    @PublicApiMember
    public void setFolderId(String folderId) {
        this.folderId = folderId;
    }

    public String getOriginPatternId() {
        return this.originPatternId;
    }

    public void setOriginPatternId(String originPatternId) {
        this.originPatternId = originPatternId;
    }

    @Override
    public Map<String, InternalMetadata> get$metadata() {
        return this.$metadata;
    }

    @PublicApiMember
    public List<TrackedItem> getTrackedItems() {
        return this.trackedItems;
    }

    @PublicApiMember
    public void setTrackedItems(List<TrackedItem> trackedItems) {
        this.trackedItems = trackedItems;
    }

    @PublicApiMember
    public List<Stage> getStages() {
        return this.stages;
    }

    @PublicApiMember
    public void setStages(List<Stage> stages) {
        this.stages = stages;
    }

    public void addReleaseId(String releaseId) {
        this.releaseIds.add(releaseId);
    }

    public void addReleaseIds(Set<String> releaseIds) {
        this.releaseIds.addAll(releaseIds);
    }

    public void addTrackedItem(TrackedItem item) {
        this.trackedItems.add(item);
    }

    public void removeTrackedItem(String itemId) {
        this.trackedItems.removeIf(item -> Ids.getName((String)item.getId()).equals(Ids.getName((String)itemId)));
    }

    @PublicApiMember
    public Integer getPlannedDuration() {
        return this.plannedDuration;
    }

    public void setPlannedDuration(Integer plannedDuration) {
        this.plannedDuration = plannedDuration;
    }

    public List<Subscriber> getSubscribers() {
        return this.subscribers;
    }

    public void setSubscribers(List<Subscriber> subscribers) {
        this.subscribers = subscribers;
    }

    public void computeReleasesFromTrackedItems() {
        HashSet<String> updatedReleaseIds = new HashSet<String>();
        this.trackedItems.forEach(item -> updatedReleaseIds.addAll(item.getReleaseIds()));
        this.setReleaseIds(updatedReleaseIds);
    }

    public boolean isAutoComplete() {
        return this.autoComplete;
    }

    public void setAutoComplete(boolean autoComplete) {
        this.autoComplete = autoComplete;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }
}

