/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseOperation;
import com.xebialabs.xlrelease.service.PostAction;
import com.xebialabs.xlrelease.user.User;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import scala.Tuple3;

public class Changes {
    private DateTime lastComment;
    private Set<ConfigurationItem> updatedItems = Sets.newLinkedHashSet();
    private Multimap<Task, Tuple3<User, String, DateTime>> commentsByTask = ArrayListMultimap.create();
    private Multimap<Task, Attachment> attachmentsByTaskId = ArrayListMultimap.create();
    private Multimap<Task, Attachment> linkedAttachments = ArrayListMultimap.create();
    private Set<String> removedIds = Sets.newLinkedHashSet();
    private List<PostAction> postActions = Lists.newArrayList();
    private List<Task> tasksToBackup = Lists.newArrayList();
    private List<XLReleaseOperation> operations = new ArrayList<XLReleaseOperation>();
    private Set<String> variablesUsed = new HashSet<String>();

    public Changes() {
        this.lastComment = DateTime.now();
    }

    public void addAll(Changes changes) {
        this.updatedItems.addAll(changes.getUpdatedItems());
        this.commentsByTask.putAll(changes.getCommentsByTask());
        this.removedIds.addAll(changes.getRemovedIds());
        this.postActions.addAll(changes.getPostActions());
        this.tasksToBackup.addAll(changes.getTasksToBackup());
        this.operations.addAll(changes.getOperations());
    }

    public void update(ConfigurationItem item) {
        this.updatedItems.add(item);
    }

    public void updateAll(Collection<? extends ConfigurationItem> items) {
        this.updatedItems.addAll(items);
    }

    public void addComment(Task task, String comment) {
        this.addComment(task, null, comment);
    }

    public void addComment(Task task, User user, String comment) {
        if (!Strings.isBlank((String)comment)) {
            DateTime now = DateTime.now();
            this.lastComment = now.isAfter((ReadableInstant)this.lastComment) ? now : this.lastComment.plusMillis(1);
            this.commentsByTask.put((Object)task, (Object)new Tuple3((Object)user, (Object)comment, (Object)this.lastComment));
        }
    }

    public void addPostAction(PostAction postAction) {
        this.postActions.add(postAction);
    }

    public void remove(String id) {
        this.removedIds.add(id);
    }

    public boolean hasUpdatedItems() {
        return !this.updatedItems.isEmpty();
    }

    public Set<ConfigurationItem> getUpdatedItems() {
        return this.updatedItems;
    }

    public ConfigurationItem[] toUpdatedItemsArray() {
        return this.updatedItems.toArray(new ConfigurationItem[this.updatedItems.size()]);
    }

    public Multimap<Task, Tuple3<User, String, DateTime>> getCommentsByTask() {
        return this.commentsByTask;
    }

    public Multimap<Task, Attachment> getAttachmentsByTask() {
        return this.attachmentsByTaskId;
    }

    public Set<String> getRemovedIds() {
        return this.removedIds;
    }

    public List<PostAction> getPostActions() {
        return this.postActions;
    }

    public List<XLReleaseOperation> getOperations() {
        return this.operations;
    }

    public void addOperation(XLReleaseOperation operation) {
        this.operations.add(operation);
    }

    public void addOperations(List<XLReleaseOperation> operations) {
        this.operations.addAll(operations);
    }

    public void addAttachment(Task task, Attachment attachment) {
        this.attachmentsByTaskId.put((Object)task, (Object)attachment);
    }

    public List<Task> getTasksToBackup() {
        return this.tasksToBackup;
    }

    public void addTaskToBackup(Task task) {
        this.tasksToBackup.add(task);
    }

    public void addVariablesUsed(Collection<String> variableNamesUsed) {
        this.variablesUsed.addAll(variableNamesUsed);
    }

    public Set<String> getVariablesUsed() {
        return Collections.unmodifiableSet(this.variablesUsed);
    }

    @SafeVarargs
    public final void addOperationBefore(XLReleaseOperation operation, Class<? extends XLReleaseOperation> ... operationBeforeClazzez) {
        for (int i = 0; i < this.operations.size(); ++i) {
            XLReleaseOperation existingOperation = this.operations.get(i);
            if (!Arrays.stream(operationBeforeClazzez).anyMatch(clazz -> clazz.isInstance(existingOperation))) continue;
            this.operations.add(i, operation);
            return;
        }
        this.operations.add(operation);
    }

    public void linkScriptOutputLog(Task task, String artifactId) {
        Release release = task.getRelease();
        Attachment attachment = new Attachment();
        attachment.setContentType("text/plain");
        attachment.setId(artifactId);
        release.getAttachments().add(attachment);
        task.getAttachments().add(attachment);
        this.update(task.getRelease());
        this.update((ConfigurationItem)task);
        this.linkedAttachments.put((Object)task, (Object)attachment);
    }

    public Multimap<Task, Attachment> getLinkedAttachments() {
        return this.linkedAttachments;
    }

    public static class VariablesChanges
    implements Serializable {
        public static final VariablesChanges EMPTY = new VariablesChanges();
        private final List<Variable> createdVariables = new ArrayList<Variable>();
        private final List<Variable> updatedVariables = new ArrayList<Variable>();
        private final List<Variable> deletedVariables = new ArrayList<Variable>();
        private final List<XLReleaseOperation> operations = new ArrayList<XLReleaseOperation>();

        public List<Variable> getCreatedVariables() {
            return this.createdVariables;
        }

        public List<Variable> getUpdatedVariables() {
            return this.updatedVariables;
        }

        public List<Variable> getDeletedVariables() {
            return this.deletedVariables;
        }

        public List<XLReleaseOperation> getOperations() {
            return this.operations;
        }
    }
}

