/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.environments;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.environments.StatusGroup;
import com.xebialabs.xlrelease.serialization.json.jackson.CiSerializer;
import java.util.Date;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(description="Entity that represents current state of deployment", versioned=false, root=Metadata.ConfigurationItemRoot.CONFIGURATION)
@JsonSerialize(using=CiSerializer.class)
public class DeploymentState
extends BaseConfiguration {
    @Property(description="General status of deployment, value of Status Group can be one of: success, in-progress, failed.")
    private StatusGroup statusGroup = StatusGroup.DEFAULT;
    @Property(description="Deployment server status label, value of a Status can be anything that is defined by deployment server.")
    private String status;
    @Property(description="Direct link to deployed application defined by deployment server.")
    private String deploymentLink;
    @Property(description="Deployment version tag defined by deployment server.")
    private String versionTag;
    @Property(description="Deloyment version state, e.g. if deployment server is GitOps driven value would be Synced/OutOfSync.")
    private String versionState;
    @Property(description="Tooltip shown for version tag defined by deployment server.")
    private String versionTooltip;
    @Property(description="Link to deployed version of application defined by deployment server.")
    private String versionLink;
    @Property(description="Deployment type which lead to version change within deployment server.")
    private String deploymentType;
    @Property(description="User which initiated or triggered deployment withing deployment server.")
    private String user;
    @Property(description="Date and time of last deployment state change.")
    private Date lastChangeTime;

    public static DeploymentState create(StatusGroup statusGroup, String status, String deepLink, String versionTag, String versionState, String versionLink, String versionTooltip, String deploymentType, String user, Date time) {
        DeploymentState liveDeployment = new DeploymentState();
        liveDeployment.setStatusGroup(statusGroup);
        liveDeployment.setStatus(status);
        liveDeployment.setDeploymentLink(deepLink);
        liveDeployment.setVersionTag(versionTag);
        liveDeployment.setVersionState(versionState);
        liveDeployment.setVersionLink(versionLink);
        liveDeployment.setVersionTooltip(versionTooltip);
        liveDeployment.setDeploymentType(deploymentType);
        liveDeployment.setUser(user);
        liveDeployment.setLastChangeTime(time);
        return liveDeployment;
    }

    public StatusGroup getStatusGroup() {
        return this.statusGroup;
    }

    public void setStatusGroup(StatusGroup statusGroup) {
        this.statusGroup = statusGroup;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getVersionTag() {
        return this.versionTag;
    }

    public void setVersionTag(String versionTag) {
        this.versionTag = versionTag;
    }

    public String getVersionState() {
        return this.versionState;
    }

    public void setVersionState(String versionState) {
        this.versionState = versionState;
    }

    public String getDeploymentType() {
        return this.deploymentType;
    }

    public void setDeploymentType(String deploymentType) {
        this.deploymentType = deploymentType;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Date getLastChangeTime() {
        return this.lastChangeTime;
    }

    public void setLastChangeTime(Date lastChangeTime) {
        this.lastChangeTime = lastChangeTime;
    }

    public String getDeploymentLink() {
        return this.deploymentLink;
    }

    public void setDeploymentLink(String deploymentLink) {
        this.deploymentLink = deploymentLink;
    }

    public String getVersionTooltip() {
        return this.versionTooltip;
    }

    public void setVersionTooltip(String versionTooltip) {
        this.versionTooltip = versionTooltip;
    }

    public String getVersionLink() {
        return this.versionLink;
    }

    public void setVersionLink(String versionLink) {
        this.versionLink = versionLink;
    }
}

