/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.forms.CopyTemplate;
import com.xebialabs.xlrelease.api.v1.forms.CreateRelease;
import com.xebialabs.xlrelease.api.v1.forms.StartRelease;
import com.xebialabs.xlrelease.api.v1.forms.Variable;
import com.xebialabs.xlrelease.api.v1.forms.VariableOrValue;
import com.xebialabs.xlrelease.api.v1.views.TeamView;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseKind;
import com.xebialabs.xlrelease.param.IdParam;
import com.xebialabs.xlrelease.rest.AllCILevels;
import com.xebialabs.xlrelease.views.ImportResult;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

@Path(value="/api/v1/templates")
@AllCILevels
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@PublicApi
@ShowOnlyPublicApiMembers
public interface TemplateApi
extends ApiService {
    public static final String SERVICE_NAME = "templateApi";

    @Override
    default public String serviceName() {
        return SERVICE_NAME;
    }

    @Deprecated(since="24.1.0")
    @GET
    @PublicApiMember
    public List<Release> getTemplates(@QueryParam(value="title") String var1, @QueryParam(value="tag") List<String> var2, @DefaultValue(value="RELEASE") @QueryParam(value="kind") String var3, @DefaultValue(value="0") @QueryParam(value="page") Long var4, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") Long var5, @DefaultValue(value="1") @QueryParam(value="depth") Integer var6);

    @Deprecated(since="24.1.0")
    @PublicApiMember
    default public List<Release> getTemplates(String title, List<String> tags, Long page, Long resultsPerPage, Integer depth) {
        return this.getTemplates(title, tags, ReleaseKind.RELEASE.name(), page, resultsPerPage, depth);
    }

    @GET
    @PublicApiMember
    public List<Release> getTemplates(@QueryParam(value="title") String var1, @QueryParam(value="tag") List<String> var2, @DefaultValue(value="RELEASE") @QueryParam(value="kind") String var3, @DefaultValue(value="0") @QueryParam(value="page") Long var4, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") Long var5);

    @PublicApiMember
    default public List<Release> getTemplates(String title, List<String> tags, Long page, Long resultsPerPage) {
        return this.getTemplates(title, tags, ReleaseKind.RELEASE.name(), page, resultsPerPage);
    }

    @Deprecated(since="24.1.0")
    @PublicApiMember
    public List<Release> getTemplates(String var1);

    @PUT
    @Path(value="/{templateId:.*Release[^/]*}")
    @PublicApiMember
    public Release updateTemplate(@PathParam(value="templateId") String var1, Release var2);

    @PublicApiMember
    default public Release updateTemplate(Release template) {
        return this.updateTemplate(template.getId(), template);
    }

    @POST
    @PublicApiMember
    public Release createTemplate(Release var1, @QueryParam(value="folderId") String var2);

    @POST
    @Path(value="/import")
    @Consumes(value={"application/json"})
    @PublicApiMember
    public List<ImportResult> importTemplate(String var1, @QueryParam(value="folderId") String var2, @QueryParam(value="version") String var3);

    @PublicApiMember
    public List<ImportResult> importTemplate(String var1, String var2);

    @POST
    @Path(value="/import")
    @Consumes(value={"multipart/form-data"})
    public List<ImportResult> importTemplateAsXlr(@Context HttpServletRequest var1, @QueryParam(value="folderId") String var2) throws IOException;

    @GET
    @Path(value="/{templateId:.*Release[^/]*}")
    @PublicApiMember
    public Release getTemplate(@PathParam(value="templateId") String var1);

    @DELETE
    @Path(value="/{templateId:.*Release[^/]*}")
    @PublicApiMember
    public void deleteTemplate(@PathParam(value="templateId") String var1);

    @POST
    @Path(value="/{templateId:.*Release[^/]*}/create")
    @PublicApiMember
    public Release create(@PathParam(value="templateId") String var1, CreateRelease var2);

    @POST
    @Path(value="/{templateId:.*Release[^/]*}/start")
    @PublicApiMember
    public Release start(@PathParam(value="templateId") String var1, StartRelease var2);

    @GET
    @Path(value="/{templateId:.*Release[^/]*}/variables")
    @PublicApiMember
    public List<com.xebialabs.xlrelease.domain.variables.Variable> getVariables(@PathParam(value="templateId") String var1);

    @GET
    @Path(value="/{variableId:.*/Variable[^/]*}")
    @PublicApiMember
    public com.xebialabs.xlrelease.domain.variables.Variable getVariable(@PathParam(value="variableId") String var1);

    @GET
    @Path(value="/{variableId:.*/Variable[^/]*}/possibleValues")
    @PublicApiMember
    public Collection<Object> getVariablePossibleValues(@PathParam(value="variableId") String var1);

    @GET
    @Path(value="/{variableId:.*/Variable[^/]*}/used")
    @PublicApiMember
    public Boolean isVariableUsed(@PathParam(value="variableId") String var1);

    @POST
    @Path(value="/{variableId:.*/Variable[^/]*}/replace")
    @PublicApiMember
    public void replaceVariable(@PathParam(value="variableId") String var1, VariableOrValue var2);

    @DELETE
    @Path(value="/{variableId:.*/Variable[^/]*}")
    @PublicApiMember
    public void deleteVariable(@PathParam(value="variableId") String var1);

    @POST
    @Path(value="/{templateId:.*Release[^/]*}/variables")
    @PublicApiMember
    public com.xebialabs.xlrelease.domain.variables.Variable createVariable(@PathParam(value="templateId") String var1, Variable var2);

    @PUT
    @Path(value="/{releaseId:.*Release[^/]*}/variables")
    @PublicApiMember
    public List<com.xebialabs.xlrelease.domain.variables.Variable> updateVariables(@PathParam(value="releaseId") String var1, List<com.xebialabs.xlrelease.domain.variables.Variable> var2);

    @PUT
    @Path(value="/{variableId:.*/Variable[^/]*}")
    public com.xebialabs.xlrelease.domain.variables.Variable updateVariable(@PathParam(value="variableId") String var1, com.xebialabs.xlrelease.domain.variables.Variable var2);

    @PublicApiMember
    default public com.xebialabs.xlrelease.domain.variables.Variable updateVariable(com.xebialabs.xlrelease.domain.variables.Variable variable) {
        return this.updateVariable(variable.getId(), variable);
    }

    @GET
    @Path(value="/permissions")
    @PublicApiMember
    public List<String> getPermissions();

    @GET
    @Path(value="/{templateId:.*Release[^/]*}/teams")
    @PublicApiMember
    public List<TeamView> getTeams(@PathParam(value="templateId") String var1);

    @POST
    @Path(value="/{templateId:.*Release[^/]*}/teams")
    @PublicApiMember
    public List<TeamView> setTeams(@PathParam(value="templateId") String var1, List<TeamView> var2);

    @GET
    @Path(value="zip/{templateId:.*Release[^/]*}")
    @PublicApiMember
    @Produces(value={"application/octet-stream"})
    public Response exportTemplateToZip(@PathParam(value="templateId") @IdParam String var1);

    @POST
    @Path(value="/{templateId:.*Release[^/]*}/copy")
    public Release copyTemplate(@PathParam(value="templateId") String var1, CopyTemplate var2);

    @PublicApiMember
    default public Release copyTemplate(String templateId, String title, String description) {
        CopyTemplate copyTemplate = new CopyTemplate();
        copyTemplate.setTitle(title);
        copyTemplate.setDescription(description);
        return this.copyTemplate(templateId, copyTemplate);
    }

    @GET
    @Path(value="logo/{logoId:.*/TemplateLogo[^/]*}")
    @Produces(value={"application/octet-stream"})
    public Response downloadTemplateLogo(@PathParam(value="logoId") String var1) throws IOException;
}

