/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.forms.Comment;
import com.xebialabs.xlrelease.api.v1.forms.Condition;
import com.xebialabs.xlrelease.api.v1.forms.StartTask;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateCondition;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.rest.AllCILevels;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.io.IOException;
import java.util.List;

@Path(value="/api/v1/tasks/")
@AllCILevels
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@PublicApi
@ShowOnlyPublicApiMembers
public interface TaskApi
extends ApiService {
    public static final String SERVICE_NAME = "taskApi";

    @Override
    default public String serviceName() {
        return SERVICE_NAME;
    }

    @POST
    @Path(value="{taskId:.*/Task[^/]*}/attachments")
    @Consumes(value={"multipart/form-data"})
    public List<Attachment> addAttachments(@PathParam(value="taskId") String var1, @Context HttpServletRequest var2) throws IOException;

    @PublicApiMember
    public Attachment addAttachment(String var1, String var2, byte[] var3) throws IOException;

    @DELETE
    @Path(value="{taskId:.*/Task[^/]*}/attachments/{attachmentId:.*/Attachment[^/]*}")
    @PublicApiMember
    public void deleteAttachment(@PathParam(value="taskId") String var1, @PathParam(value="attachmentId") String var2);

    @GET
    @Path(value="/{taskId:.*/Task[^/]*}")
    @PublicApiMember
    public Task getTask(@PathParam(value="taskId") String var1);

    @POST
    @Path(value="{taskId:.*/Task[^/]*}/copy")
    @PublicApiMember
    public Task copyTask(@PathParam(value="taskId") String var1, @QueryParam(value="targetContainerId") String var2, @QueryParam(value="targetPosition") int var3);

    @PublicApiMember
    public Task updateTask(Task var1);

    @PUT
    @Path(value="/{taskId:.*/Task[^/]*}")
    public Task updateTask(@PathParam(value="taskId") String var1, Task var2);

    @PublicApiMember
    public Task updateTask(String var1, Task var2, boolean var3);

    @POST
    @Path(value="{taskId:.*/Task[^/]*}/changeType")
    @PublicApiMember
    public Task changeTaskType(@PathParam(value="taskId") String var1, @QueryParam(value="targetType") String var2);

    @POST
    @Path(value="/{containerId:.*?}/tasks")
    @PublicApiMember
    public Task addTask(@PathParam(value="containerId") String var1, Task var2);

    @POST
    @Path(value="/{containerId:.*?}/tasks")
    public Task addTask(@PathParam(value="containerId") String var1, Task var2, Integer var3);

    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/complete")
    @PublicApiMember
    public Task completeTask(@PathParam(value="taskId") String var1, Comment var2);

    @PublicApiMember
    public Task completeTask(String var1, String var2);

    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/skip")
    @PublicApiMember
    public Task skipTask(@PathParam(value="taskId") String var1, Comment var2);

    @PublicApiMember
    public Task skipTask(String var1, String var2);

    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/fail")
    @PublicApiMember
    public Task failTask(@PathParam(value="taskId") String var1, Comment var2);

    @PublicApiMember
    public Task failTask(String var1, String var2);

    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/abort")
    @PublicApiMember
    public Task abortTask(@PathParam(value="taskId") String var1, Comment var2);

    @PublicApiMember
    public Task abortTask(String var1, String var2);

    @PublicApiMember
    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/retry")
    public Task retryTask(@PathParam(value="taskId") String var1, Comment var2);

    @PublicApiMember
    public Task retryTask(String var1, String var2);

    @PublicApiMember
    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/startNow")
    public Task start(@PathParam(value="taskId") String var1, Comment var2);

    @PublicApiMember
    public Task start(String var1, String var2);

    @PublicApiMember
    public Task start(Task var1, List<Variable> var2);

    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/start")
    public Task start(@PathParam(value="taskId") String var1, StartTask var2);

    @PublicApiMember
    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/reopen")
    public Task reopenTask(@PathParam(value="taskId") String var1, Comment var2);

    @PublicApiMember
    public Task reopenTask(String var1, String var2);

    @GET
    @Path(value="/{taskId:.*/Task[^/]*}/variables")
    @PublicApiMember
    public List<Variable> getVariables(@PathParam(value="taskId") String var1);

    @PUT
    @Path(value="/{taskId:.*/Task[^/]*}/variables")
    @PublicApiMember
    public List<Variable> updateInputVariables(@PathParam(value="taskId") String var1, List<Variable> var2);

    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/comment")
    @PublicApiMember
    public Task commentTask(@PathParam(value="taskId") String var1, Comment var2);

    @PublicApiMember
    public Task commentTask(String var1, String var2);

    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/assign/{username: .*?}")
    @PublicApiMember
    public Task assignTask(@PathParam(value="taskId") String var1, @PathParam(value="username") String var2);

    @GET
    @Path(value="/byTitle")
    @PublicApiMember
    public List<Task> searchTasksByTitle(@QueryParam(value="taskTitle") String var1, @QueryParam(value="phaseTitle") String var2, @QueryParam(value="releaseId") String var3);

    @PublicApiMember
    public Task newTask();

    @PublicApiMember
    public Task newTask(String var1);

    public Comment newComment(String var1);

    @DELETE
    @Path(value="/{taskId:.*/Task[^/]*}")
    @PublicApiMember
    public void delete(@PathParam(value="taskId") String var1);

    @DELETE
    @Path(value="/{dependencyId:.*/Dependency[^/]*}")
    @PublicApiMember
    public void deleteDependency(@PathParam(value="dependencyId") String var1);

    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/dependencies/{targetId:.*?}")
    @PublicApiMember
    public Dependency addDependency(@PathParam(value="taskId") String var1, @PathParam(value="targetId") String var2);

    @POST
    @Path(value="{taskId:.*/Task[^/]*}/conditions")
    @PublicApiMember
    public GateCondition addCondition(@PathParam(value="taskId") String var1, Condition var2);

    @POST
    @Path(value="/{conditionId:.*/GateCondition[^/]*}")
    public GateCondition updateCondition(@PathParam(value="conditionId") String var1, Condition var2);

    @PublicApiMember
    public GateCondition updateCondition(GateCondition var1);

    @DELETE
    @Path(value="{conditionId:.*/GateCondition[^/]*?}")
    @PublicApiMember
    public void deleteCondition(@PathParam(value="conditionId") String var1);

    @PUT
    @PublicApiMember
    @Path(value="{taskId:.*/Task[^/]*}/lock")
    public void lockTask(@PathParam(value="taskId") String var1);

    @DELETE
    @PublicApiMember
    @Path(value="{taskId:.*/Task[^/]*}/lock")
    public void unlockTask(@PathParam(value="taskId") String var1);
}

