/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.overthere;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.ssh.SshConnectionType;
import com.xebialabs.overthere.util.OverthereFileTranscoder;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.plugin.overthere.NonClosingWriterOutputHandler;
import com.xebialabs.xlrelease.plugin.overthere.OutputHandler;
import com.xebialabs.xlrelease.plugin.overthere.PasswordMasker;
import com.xebialabs.xlrelease.plugin.overthere.PasswordMaskingOutputHandler;
import com.xebialabs.xlrelease.plugin.overthere.RingWriterOutputHandler;
import com.xebialabs.xlrelease.plugin.overthere.TaskExecutionLogHelper;
import com.xebialabs.xlrelease.plugin.overthere.TaskExecutionLogOutputHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteScript {
    private static final String SCRIPT_NAME = "uploaded-script";
    private final ConnectionOptions options = new ConnectionOptions();
    private final String protocol;
    private final Writer stdoutWriter;
    private final String remotePath;
    private final String script;
    private final String extension;
    private final PythonScript pythonScript;
    private String stdOut;
    private String stdErr;
    private static final Logger logger = LoggerFactory.getLogger(RemoteScript.class);

    public RemoteScript(PythonScript pythonScript, Writer stdoutWriter) {
        this.pythonScript = pythonScript;
        this.protocol = (String)pythonScript.getProperty("protocol");
        this.stdoutWriter = stdoutWriter;
        this.copyPropertiesToConnectionOptions(this.options, (ConfigurationItem)pythonScript);
        OperatingSystemFamily osFamily = (OperatingSystemFamily)this.options.get("os", (Object)OperatingSystemFamily.UNIX);
        String scriptContent = (String)pythonScript.getProperty("script");
        this.script = scriptContent != null ? scriptContent.replaceAll("\\R", osFamily.getLineSeparator()) : null;
        this.extension = osFamily.getScriptExtension();
        this.remotePath = (String)pythonScript.getProperty("remotePath");
    }

    protected void copyPropertiesToConnectionOptions(ConnectionOptions options, ConfigurationItem ci) {
        if (ci.hasProperty("sudo") && ((Boolean)ci.getProperty("sudo")).booleanValue()) {
            ci.setProperty("connectionType", (Object)SshConnectionType.SUDO);
            ci.setProperty("sudoUsername", (Object)"root");
        }
        for (PropertyDescriptor pd : ci.getType().getDescriptor().getPropertyDescriptors()) {
            if (pd.getCategory().equals("output")) continue;
            Object value = pd.get(ci);
            this.setConnectionOption(options, pd.getName(), value);
        }
    }

    private void setConnectionOption(ConnectionOptions options, String key, Object value) {
        if (key.equals("script") || key.equals("remotePath") || key.equals("scriptLocation")) {
            return;
        }
        if (value == null || value.toString().isEmpty()) {
            return;
        }
        if (key.equals("temporaryDirectoryPath")) {
            key = "tmp";
        } else if (key.equals("timeout")) {
            key = "winrmTimeout";
        }
        if (value instanceof Integer && (Integer)value == 0) {
            logger.debug("Activating workaround for DEPLOYITPB-4775: Integer with value of 0 not passed to Overthere.");
            return;
        }
        if (key.equals("jumpstation")) {
            ConfigurationItem item = (ConfigurationItem)value;
            ConnectionOptions jumpstationOptions = new ConnectionOptions();
            this.copyPropertiesToConnectionOptions(jumpstationOptions, item);
            options.set(key, (Object)jumpstationOptions);
        } else {
            options.set(key, value);
        }
    }

    /*
     * Exception decompiling
     */
    public int execute() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private OutputHandler createOutputHandler(TaskExecutionLogHelper taskExecutionLogHelper, PasswordMasker passwordMasker, int maxSize) {
        return new PasswordMaskingOutputHandler(new TaskExecutionLogOutputHandler(new NonClosingWriterOutputHandler(new RingWriterOutputHandler(maxSize), this.stdoutWriter), taskExecutionLogHelper), passwordMasker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doExecute(OverthereConnection connection, OutputHandler stdoutHandler, OutputHandler stderrHandler) throws IOException {
        try {
            if (this.remotePath != null && !this.remotePath.isEmpty()) {
                connection.setWorkingDirectory(connection.getFile(this.remotePath));
            }
            OverthereFile targetFile = connection.getTempFile(SCRIPT_NAME, this.extension);
            OverthereFileTranscoder.transcode((String)this.script, (String)"UTF-8", (OverthereFile)targetFile);
            targetFile.setExecutable(true);
            CmdLine scriptCommand = CmdLine.build((String[])new String[]{targetFile.getPath()});
            int n = connection.execute((OverthereExecutionOutputHandler)stdoutHandler, (OverthereExecutionOutputHandler)stderrHandler, scriptCommand);
            return n;
        }
        catch (Exception e) {
            String stackTrace = RemoteScript.captureStackTrace(e);
            stderrHandler.handleLine(stackTrace);
            int n = 1;
            return n;
        }
        finally {
            this.stdOut = this.getOutput(stdoutHandler);
            this.stdErr = this.getOutput(stderrHandler);
        }
    }

    private static String captureStackTrace(Exception e) throws IOException {
        try (StringWriter stacktrace = new StringWriter();){
            PrintWriter writer = new PrintWriter((Writer)stacktrace, true);
            try {
                e.printStackTrace(writer);
                String string = stacktrace.toString();
                writer.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public String getStdout() {
        return this.stdOut;
    }

    public String getStderr() {
        return this.stdErr;
    }

    private String getOutput(OutputHandler outputHandler) throws IOException {
        return outputHandler.getStringContent();
    }

    public ConnectionOptions getOptions() {
        return this.options;
    }

    public String getScript() {
        return this.script;
    }
}

