/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.overthere;

import com.xebialabs.xlrelease.plugin.overthere.OutputHandler;
import java.io.IOException;
import java.io.Writer;

class NonClosingWriterOutputHandler
implements OutputHandler {
    private final OutputHandler outputHandler;
    private final Writer writer;

    public NonClosingWriterOutputHandler(OutputHandler outputHandler, Writer output) {
        this.outputHandler = outputHandler;
        this.writer = output;
    }

    @Override
    public void close() throws IOException {
        this.writer.flush();
    }

    @Override
    public String getStringContent() throws IOException {
        return this.outputHandler != null ? this.outputHandler.getStringContent() : "";
    }

    public void handleChar(char c) {
    }

    public void handleLine(String line) {
        try {
            this.writer.write(line);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.outputHandler != null) {
            this.outputHandler.handleLine(line);
        }
    }
}

