/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.overthere;

import com.xebialabs.xlrelease.plugin.overthere.TaskExecutionLogOutputStream;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionLogService;
import com.xebialabs.xlrelease.storage.service.LogSizeLimitExceededException;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TaskExecutionLogHelper
extends BufferedOutputStream {
    private static final Logger logger = LoggerFactory.getLogger(TaskExecutionLogHelper.class);
    private volatile boolean running = true;
    private ScheduledFuture<?> cancelableTimer;

    public TaskExecutionLogHelper(TaskExecutionLogOutputStream outputStream, Duration pollingInterval, ScheduledExecutorService executor) {
        super(outputStream, TaskExecutionLogService.DEFAULT_CHUNK_BUFFER_SIZE());
        Runnable timerTask = this::flushBuffer;
        this.cancelableTimer = executor.scheduleAtFixedRate(timerTask, pollingInterval.toMillis(), pollingInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void log(String line) {
        if (!this.running) {
            logger.debug("Log helper no longer running, skipping the line");
            return;
        }
        try {
            this.write(line.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            logger.error("Failed to log a line", (Throwable)e);
        }
        catch (LogSizeLimitExceededException ex) {
            logger.debug("Log size limit exceeded", (Throwable)ex);
            this.stop();
        }
    }

    public void flushBuffer() {
        try {
            this.flush();
        }
        catch (IOException e) {
            logger.error("Failed to flush the buffer", (Throwable)e);
        }
    }

    public void stop() {
        this.cancelableTimer.cancel(true);
        this.running = false;
    }

    @Override
    public void close() throws IOException {
        this.stop();
        super.close();
    }
}

