/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.overthere.util;

import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.overthere.util.CapturingOverthereExecutionOutputHandler;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.plugin.overthere.util.RemoteScriptPasswordMasker;
import com.xebialabs.xlrelease.plugin.overthere.util.TaskExecutionLogHelper;

public class StorageOutputHandler
implements OverthereExecutionOutputHandler {
    private final CapturingOverthereExecutionOutputHandler stdOut;
    private final CapturingOverthereExecutionOutputHandler stdErr;
    private final TaskExecutionLogHelper taskExecutionLogHelper;
    private final RemoteScriptPasswordMasker remoteScriptPasswordMasker;
    private final PythonScript pythonScript;
    private final boolean isErrorHandler;

    public StorageOutputHandler(PythonScript pythonScript, TaskExecutionLogHelper taskExecutionLogHelper, boolean isErrorHandler) {
        this.pythonScript = pythonScript;
        this.taskExecutionLogHelper = taskExecutionLogHelper;
        this.isErrorHandler = isErrorHandler;
        this.stdOut = CapturingOverthereExecutionOutputHandler.capturingHandler();
        this.stdErr = CapturingOverthereExecutionOutputHandler.capturingHandler();
        this.remoteScriptPasswordMasker = new RemoteScriptPasswordMasker(pythonScript);
    }

    public void handleChar(char c) {
    }

    public void handleLine(String line) {
        String lineWithMaskedPasswords = this.remoteScriptPasswordMasker.maskPassword(this.pythonScript, line);
        if (this.isErrorHandler) {
            this.stdErr.handleLine(lineWithMaskedPasswords);
        } else {
            this.stdOut.handleLine(lineWithMaskedPasswords);
        }
        this.taskExecutionLogHelper.log(lineWithMaskedPasswords);
    }

    public String getOutput() {
        if (this.isErrorHandler) {
            return this.stdErr.getOutput();
        }
        return this.stdOut.getOutput();
    }
}

