/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven.logic;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.maven.MavenDeployed;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomDeployedsApplicationStrategy {
    Logger log = LoggerFactory.getLogger(CustomDeployedsApplicationStrategy.class);

    public Deployment merge(Deployment input, List<MavenDeployed> custom) {
        List deployeds = input.getDeployeds();
        for (ConfigurationItem configurationItem : deployeds) {
            this.log.debug(" check {}", (Object)configurationItem);
            final String id = configurationItem.getId();
            UnmodifiableIterator deployedIterator = Iterators.filter(custom.iterator(), (Predicate)new Predicate<MavenDeployed>(){

                public boolean apply(MavenDeployed input) {
                    return input.getId().equals(id);
                }
            });
            if (deployedIterator.hasNext()) {
                this.updateConfigurationItemValues(configurationItem, (MavenDeployed)deployedIterator.next());
                continue;
            }
            this.log.debug(" no configured deployed found with id " + configurationItem.getId());
        }
        return input;
    }

    private void updateConfigurationItemValues(ConfigurationItem configurationItem, MavenDeployed configuredDeployed) {
        this.log.debug(" update values of {} with {}", (Object)configurationItem.getId(), configuredDeployed.getValues());
        for (Map.Entry<String, Object> e : configuredDeployed.getValues().entrySet()) {
            configurationItem.setProperty(e.getKey(), e.getValue());
        }
        if (configuredDeployed.getPlaceholders() != null && !configuredDeployed.getPlaceholders().isEmpty()) {
            configurationItem.setProperty("placeholders", configuredDeployed.getPlaceholders());
        }
    }
}

