/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.maven.Container;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import java.util.Map;
import java.util.Set;

public class MavenContainer
extends Container {
    protected String type;
    protected String id;
    protected boolean addedToEnvironment = true;
    protected final Map<String, Object> properties = Maps.newHashMap();

    public String getType() {
        return this.type;
    }

    public String getId() {
        if (this.id == null) {
            throw new IllegalStateException("id cannot be null");
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isAddedToEnvironment() {
        return this.addedToEnvironment;
    }

    public void setAddedToEnvironment(boolean addedToEnvironment) {
        this.addedToEnvironment = addedToEnvironment;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String toString() {
        Set<Map.Entry<String, Object>> entries = this.getProperties().entrySet();
        Object properties = "{";
        boolean first = false;
        for (Map.Entry<String, Object> e : entries) {
            properties = (String)properties + (first ? "," : "") + "\"" + e.getKey() + "\":\"" + String.valueOf(e.getValue()) + "\"";
            first = true;
        }
        properties = (String)properties + "}";
        return String.format("repository.create(\"%s\",factory.configurationItem(\"%s\", %s))", this.getId(), this.getType(), properties);
    }

    public void addParameter(String name, Object value) {
        if ("addedToEnvironment".equals(name)) {
            this.addedToEnvironment = Boolean.parseBoolean(value.toString());
            return;
        }
        if ("type".equals(name)) {
            this.setType(value.toString());
            return;
        }
        if ("id".equals(name)) {
            this.id = value.toString();
            return;
        }
        this.properties.put(name, value);
    }

    public ConfigurationItem asConfigurationItem() {
        BaseConfigurationItem ci = new BaseConfigurationItem();
        ci.setType(Type.valueOf((String)this.getType()));
        ci.setId(this.getId());
        for (Map.Entry<String, Object> e : this.getProperties().entrySet()) {
            if ("addedToEnvironment".equals(e.getKey())) continue;
            ci.setProperty(e.getKey(), e.getValue());
        }
        return ci;
    }
}

