/*!
 * Copyright 2017 Amazon.com,
 * Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the
 * License. A copy of the License is located at
 * 
 *      http://aws.amazon.com/apache2.0/
 * 
 * or in the "license" file accompanying this file. This file is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, express or implied. See the License
 * for the specific language governing permissions and
 * limitations under the License. 
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define([],t):"object"==typeof exports?exports.AmazonCognitoIdentity=t():e.AmazonCognitoIdentity=t()}(this,function(){return function(e){function t(s){if(n[s])return n[s].exports;var o=n[s]={exports:{},id:s,loaded:!1};return e[s].call(o.exports,o,o.exports,t),o.loaded=!0,o.exports}var n={};return t.m=e,t.c=n,t.p="",t(0)}([function(e,t,n){"use strict";function s(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&(t[n]=e[n]);return t.default=e,t}Object.defineProperty(t,"__esModule",{value:!0});var o=n(9);Object.keys(o).forEach(function(e){"default"!==e&&"__esModule"!==e&&Object.defineProperty(t,e,{enumerable:!0,get:function(){return o[e]}})});s(o);/*!
	 * Amazon Cognito Auth SDK for JavaScript
	 * Copyright 2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
	
	 * Licensed under the Apache License, Version 2.0 (the "License").
	 * You may not use this file except in compliance with the License.
	 * A copy of the License is located at
	 *
	 *         http://aws.amazon.com/apache2.0/
	 *
	 * or in the "license" file accompanying this file.
	 * This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES
	 * OR CONDITIONS OF ANY KIND, either express or implied. See the
	 * License for the specific language governing permissions
	 * and limitations under the License.
	 */
"undefined"!=typeof window&&!window.crypto&&window.msCrypto&&(window.crypto=window.msCrypto)},function(e,t){"use strict";function n(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}Object.defineProperty(t,"__esModule",{value:!0});var s=function(){function e(e,t){for(var n=0;n<t.length;n++){var s=t[n];s.enumerable=s.enumerable||!1,s.configurable=!0,"value"in s&&(s.writable=!0),Object.defineProperty(e,s.key,s)}}return function(t,n,s){return n&&e(t.prototype,n),s&&e(t,s),t}}(),o=function(){function e(t){n(this,e),this.jwtToken=t||"",this.payload=this.decodePayload()}return s(e,[{key:"getJwtToken",value:function(){return this.jwtToken}},{key:"setJwtToken",value:function(e){this.jwtToken=e}},{key:"getExpiration",value:function(){if(null!==this.jwtToken){var e=this.jwtToken.split(".")[1];return JSON.parse(atob(e)).exp}}},{key:"getUsername",value:function(){if(null!==this.jwtToken){var e=this.jwtToken.split(".")[1];return JSON.parse(atob(e)).username}}},{key:"decodePayload",value:function(){var e=this.jwtToken.split(".")[1];try{return JSON.parse(atob(e))}catch(e){return{}}}}]),e}();t.default=o},function(e,t){"use strict";function n(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}Object.defineProperty(t,"__esModule",{value:!0});var s=function(){function e(e,t){for(var n=0;n<t.length;n++){var s=t[n];s.enumerable=s.enumerable||!1,s.configurable=!0,"value"in s&&(s.writable=!0),Object.defineProperty(e,s.key,s)}}return function(t,n,s){return n&&e(t.prototype,n),s&&e(t,s),t}}(),o=function(){function e(t){n(this,e),this.jwtToken=t||"",this.payload=this.decodePayload()}return s(e,[{key:"getJwtToken",value:function(){return this.jwtToken}},{key:"setJwtToken",value:function(e){this.jwtToken=e}},{key:"getExpiration",value:function(){if(null!==this.jwtToken){var e=this.jwtToken.split(".")[1];return JSON.parse(atob(e)).exp}}},{key:"decodePayload",value:function(){var e=this.jwtToken.split(".")[1];try{return JSON.parse(atob(e))}catch(e){return{}}}}]),e}();t.default=o},function(e,t){"use strict";function n(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}Object.defineProperty(t,"__esModule",{value:!0});var s=function(){function e(e,t){for(var n=0;n<t.length;n++){var s=t[n];s.enumerable=s.enumerable||!1,s.configurable=!0,"value"in s&&(s.writable=!0),Object.defineProperty(e,s.key,s)}}return function(t,n,s){return n&&e(t.prototype,n),s&&e(t,s),t}}(),o=function(){function e(t){n(this,e),this.refreshToken=t||""}return s(e,[{key:"getToken",value:function(){return this.refreshToken}},{key:"setToken",value:function(e){this.refreshToken=e}}]),e}();t.default=o},function(e,t){"use strict";function n(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}Object.defineProperty(t,"__esModule",{value:!0});var s=function(){function e(e,t){for(var n=0;n<t.length;n++){var s=t[n];s.enumerable=s.enumerable||!1,s.configurable=!0,"value"in s&&(s.writable=!0),Object.defineProperty(e,s.key,s)}}return function(t,n,s){return n&&e(t.prototype,n),s&&e(t,s),t}}(),o=function(){function e(t){n(this,e),this.tokenScopes=t||[]}return s(e,[{key:"getScopes",value:function(){return this.tokenScopes}},{key:"setTokenScopes",value:function(e){this.tokenScopes=e}}]),e}();t.default=o},function(e,t,n){"use strict";function s(e){return e&&e.__esModule?e:{default:e}}function o(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}Object.defineProperty(t,"__esModule",{value:!0});var i=function(){function e(e,t){for(var n=0;n<t.length;n++){var s=t[n];s.enumerable=s.enumerable||!1,s.configurable=!0,"value"in s&&(s.writable=!0),Object.defineProperty(e,s.key,s)}}return function(t,n,s){return n&&e(t.prototype,n),s&&e(t,s),t}}(),r=n(4),a=s(r),u=n(1),c=s(u),g=n(2),h=s(g),l=n(3),f=s(l),d=function(){function e(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},n=t.IdToken,s=t.RefreshToken,i=t.AccessToken,r=t.TokenScopes,u=t.State;o(this,e),n?this.idToken=n:this.idToken=new h.default,s?this.refreshToken=s:this.refreshToken=new f.default,i?this.accessToken=i:this.accessToken=new c.default,r?this.tokenScopes=r:this.tokenScopes=new a.default,u?this.state=u:this.state=null}return i(e,[{key:"getIdToken",value:function(){return this.idToken}},{key:"setIdToken",value:function(e){this.idToken=e}},{key:"getRefreshToken",value:function(){return this.refreshToken}},{key:"setRefreshToken",value:function(e){this.refreshToken=e}},{key:"getAccessToken",value:function(){return this.accessToken}},{key:"setAccessToken",value:function(e){this.accessToken=e}},{key:"getTokenScopes",value:function(){return this.tokenScopes}},{key:"setTokenScopes",value:function(e){this.tokenScopes=e}},{key:"getState",value:function(){return this.state}},{key:"setState",value:function(e){this.state=e}},{key:"isValid",value:function(){var e=Math.floor(new Date/1e3);try{return null!=this.accessToken?e<this.accessToken.getExpiration():null!=this.idToken&&e<this.idToken.getExpiration()}catch(e){return!1}}}]),e}();t.default=d},function(e,t){"use strict";function n(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}Object.defineProperty(t,"__esModule",{value:!0});var s=function(){function e(e,t){for(var n=0;n<t.length;n++){var s=t[n];s.enumerable=s.enumerable||!1,s.configurable=!0,"value"in s&&(s.writable=!0),Object.defineProperty(e,s.key,s)}}return function(t,n,s){return n&&e(t.prototype,n),s&&e(t,s),t}}(),o={},i=function(){function e(){n(this,e)}return s(e,null,[{key:"setItem",value:function(e,t){return o[e]=t,o[e]}},{key:"getItem",value:function(e){return Object.prototype.hasOwnProperty.call(o,e)?o[e]:void 0}},{key:"removeItem",value:function(e){return delete o[e]}},{key:"clear",value:function(){return o={}}}]),e}(),r=function(){function e(){n(this,e);try{this.storageWindow=window.localStorage,this.storageWindow.setItem("aws.cognito.test-ls",1),this.storageWindow.removeItem("aws.cognito.test-ls")}catch(e){this.storageWindow=i}}return s(e,[{key:"getStorage",value:function(){return this.storageWindow}}]),e}();t.default=r},function(e,t,n){"use strict";function s(e){return e&&e.__esModule?e:{default:e}}function o(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}Object.defineProperty(t,"__esModule",{value:!0});var i="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},r=function(){function e(e,t){for(var n=0;n<t.length;n++){var s=t[n];s.enumerable=s.enumerable||!1,s.configurable=!0,"value"in s&&(s.writable=!0),Object.defineProperty(e,s.key,s)}}return function(t,n,s){return n&&e(t.prototype,n),s&&e(t,s),t}}(),a=n(4),u=s(a),c=n(1),g=s(c),h=n(2),l=s(h),f=n(3),d=s(f),C=n(5),S=s(C),T=n(6),p=s(T),y=function(){function e(t){o(this,e);var n=t||{},s=n.ClientId,i=n.AppWebDomain,r=n.TokenScopesArray,a=n.RedirectUriSignIn,c=n.RedirectUriSignOut,g=n.IdentityProvider,h=n.UserPoolId,l=n.AdvancedSecurityDataCollectionFlag,f=n.Storage;if(!(null!=t&&s&&i&&a&&c))throw new Error(this.getCognitoConstants().PARAMETERERROR);if(this.clientId=s,this.appWebDomain=i,this.TokenScopesArray=r||[],!Array.isArray(r))throw new Error(this.getCognitoConstants().SCOPETYPEERROR);var d=new u.default(this.TokenScopesArray);this.RedirectUriSignIn=a,this.RedirectUriSignOut=c,this.IdentityProvider=g,this.responseType=this.getCognitoConstants().TOKEN,this.storage=f||(new p.default).getStorage(),this.username=this.getLastUser(),this.userPoolId=h,this.signInUserSession=this.getCachedSession(),+this.signInUserSession.setTokenScopes(d),this.advancedSecurityDataCollectionFlag=!0,l&&(this.advancedSecurityDataCollectionFlag=l)}return r(e,[{key:"getCognitoConstants",value:function(){var e={DOMAIN_SCHEME:"https",DOMAIN_PATH_SIGNIN:"oauth2/authorize",DOMAIN_PATH_TOKEN:"oauth2/token",DOMAIN_PATH_SIGNOUT:"logout",DOMAIN_QUERY_PARAM_REDIRECT_URI:"redirect_uri",DOMAIN_QUERY_PARAM_SIGNOUT_URI:"logout_uri",DOMAIN_QUERY_PARAM_RESPONSE_TYPE:"response_type",DOMAIN_QUERY_PARAM_IDENTITY_PROVIDER:"identity_provider",DOMAIN_QUERY_PARAM_USERCONTEXTDATA:"userContextData",CLIENT_ID:"client_id",STATE:"state",SCOPE:"scope",TOKEN:"token",CODE:"code",POST:"POST",PARAMETERERROR:"The parameters: App client Id, App web domain, the redirect URL when you are signed in and the redirect URL when you are signed out are required.",SCOPETYPEERROR:"Scopes have to be array type. ",QUESTIONMARK:"?",POUNDSIGN:"#",COLONDOUBLESLASH:"://",SLASH:"/",AMPERSAND:"&",EQUALSIGN:"=",SPACE:" ",CONTENTTYPE:"Content-Type",CONTENTTYPEVALUE:"application/x-www-form-urlencoded",AUTHORIZATIONCODE:"authorization_code",IDTOKEN:"id_token",ACCESSTOKEN:"access_token",REFRESHTOKEN:"refresh_token",ERROR:"error",ERROR_DESCRIPTION:"error_description",STRINGTYPE:"string",STATELENGTH:32,STATEORIGINSTRING:"0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ",WITHCREDENTIALS:"withCredentials",UNDEFINED:"undefined",SELF:"_self",HOSTNAMEREGEX:/:\/\/([0-9]?\.)?(.[^\/:]+)/i,QUERYPARAMETERREGEX1:/#(.+)/,QUERYPARAMETERREGEX2:/=(.+)/,HEADER:{"Content-Type":"application/x-www-form-urlencoded"}};return e}},{key:"getClientId",value:function(){return this.clientId}},{key:"getAppWebDomain",value:function(){return this.appWebDomain}},{key:"getCurrentUser",value:function(){var e="CognitoIdentityServiceProvider."+this.clientId+".LastAuthUser",t=this.storage.getItem(e);return t}},{key:"setUser",value:function(e){this.username=e}},{key:"useCodeGrantFlow",value:function(){this.responseType=this.getCognitoConstants().CODE}},{key:"useImplicitFlow",value:function(){this.responseType=this.getCognitoConstants().TOKEN}},{key:"getSignInUserSession",value:function(){return this.signInUserSession}},{key:"getUsername",value:function(){return this.username}},{key:"setUsername",value:function(e){this.username=e}},{key:"getState",value:function(){return this.state}},{key:"setState",value:function(e){this.state=e}},{key:"getSession",value:function(){var e=new Set(this.TokenScopesArray),t=new Set(this.signInUserSession.tokenScopes.getScopes()),n=this.getFQDNSignIn();if(null!=this.signInUserSession&&this.signInUserSession.isValid())return this.userhandler.onSuccess(this.signInUserSession);if(this.signInUserSession=this.getCachedSession(),this.compareSets(e,t)){if(this.signInUserSession.isValid())return this.userhandler.onSuccess(this.signInUserSession);this.signInUserSession.getRefreshToken()&&this.signInUserSession.getRefreshToken().getToken()?this.refreshSession(this.signInUserSession.getRefreshToken().getToken()):this.launchUri(n)}else{var s=new u.default(this.TokenScopesArray),o=new l.default,i=new g.default,r=new d.default;this.signInUserSession.setTokenScopes(s),this.signInUserSession.setIdToken(o),this.signInUserSession.setAccessToken(i),this.signInUserSession.setRefreshToken(r),this.launchUri(n)}}},{key:"parseCognitoWebResponse",value:function(e){var t=void 0;if(e.indexOf(this.getCognitoConstants().QUESTIONMARK)>-1){var n=e.split(this.getCognitoConstants().POUNDSIGN)[0];t=this.getQueryParameters(n,this.getCognitoConstants().QUESTIONMARK),this.getCodeQueryParameter(t)}else if(e.indexOf(this.getCognitoConstants().POUNDSIGN)>-1){if(t=this.getQueryParameters(e,this.getCognitoConstants().QUERYPARAMETERREGEX1),t.has(this.getCognitoConstants().ERROR))return this.userhandler.onFailure(t.get(this.getCognitoConstants().ERROR_DESCRIPTION));this.getTokenQueryParameter(t)}}},{key:"getCodeQueryParameter",value:function(e){var t=null;if(e.has(this.getCognitoConstants().STATE)?this.signInUserSession.setState(e.get(this.getCognitoConstants().STATE)):this.signInUserSession.setState(t),e.has(this.getCognitoConstants().CODE)){var n=e.get(this.getCognitoConstants().CODE),s=this.getCognitoConstants().DOMAIN_SCHEME.concat(this.getCognitoConstants().COLONDOUBLESLASH,this.getAppWebDomain(),this.getCognitoConstants().SLASH,this.getCognitoConstants().DOMAIN_PATH_TOKEN),o=this.getCognitoConstants().HEADER,i={grant_type:this.getCognitoConstants().AUTHORIZATIONCODE,client_id:this.getClientId(),redirect_uri:this.RedirectUriSignIn,code:n},r=this.onSuccessExchangeForToken.bind(this),a=this.onFailure.bind(this);this.makePOSTRequest(o,i,s,r,a)}}},{key:"getTokenQueryParameter",value:function(e){var t=new l.default,n=new g.default,s=(new d.default,null);e.has(this.getCognitoConstants().IDTOKEN)?(t.setJwtToken(e.get(this.getCognitoConstants().IDTOKEN)),this.signInUserSession.setIdToken(t)):this.signInUserSession.setIdToken(t),e.has(this.getCognitoConstants().ACCESSTOKEN)?(n.setJwtToken(e.get(this.getCognitoConstants().ACCESSTOKEN)),this.signInUserSession.setAccessToken(n)):this.signInUserSession.setAccessToken(n),e.has(this.getCognitoConstants().STATE)?this.signInUserSession.setState(e.get(this.getCognitoConstants().STATE)):this.signInUserSession.setState(s),this.cacheTokensScopes(),this.userhandler.onSuccess(this.signInUserSession)}},{key:"getCachedSession",value:function(){if(!this.username)return new S.default;var e="CognitoIdentityServiceProvider."+this.getClientId()+"."+this.username,t=e+".idToken",n=e+".accessToken",s=e+".refreshToken",o=e+".tokenScopesString",i=this.storage.getItem(o),r=[];i&&(r=i.split(" "));var a=new u.default(r),c=new l.default(this.storage.getItem(t)),h=new g.default(this.storage.getItem(n)),f=new d.default(this.storage.getItem(s)),C={IdToken:c,AccessToken:h,RefreshToken:f,TokenScopes:a},T=new S.default(C);return T}},{key:"getLastUser",value:function(){var e="CognitoIdentityServiceProvider."+this.getClientId(),t=e+".LastAuthUser",n=this.storage.getItem(t);if(n)return n}},{key:"cacheTokensScopes",value:function(){var e="CognitoIdentityServiceProvider."+this.getClientId(),t=this.signInUserSession.getAccessToken().getUsername();this.username=t;var n=e+"."+t+".idToken",s=e+"."+t+".accessToken",o=e+"."+t+".refreshToken",i=e+".LastAuthUser",r=e+"."+t+".tokenScopesString",a=this.signInUserSession.getTokenScopes().getScopes(),u=a.join(" ");this.storage.setItem(n,this.signInUserSession.getIdToken().getJwtToken()),this.storage.setItem(s,this.signInUserSession.getAccessToken().getJwtToken()),this.storage.setItem(o,this.signInUserSession.getRefreshToken().getToken()),this.storage.setItem(i,t),this.storage.setItem(r,u)}},{key:"compareSets",value:function(e,t){if(e.size!==t.size)return!1;var n=!0,s=!1,o=void 0;try{for(var i,r=e[Symbol.iterator]();!(n=(i=r.next()).done);n=!0){var a=i.value;if(!t.has(a))return!1}}catch(e){s=!0,o=e}finally{try{!n&&r.return&&r.return()}finally{if(s)throw o}}return!0}},{key:"getHostName",value:function(e){var t=e.match(this.getCognitoConstants().HOSTNAMEREGEX);if(null!=t&&t.length>2&&i(t[2])===this.getCognitoConstants().STRINGTYPE&&t[2].length>0)return t[2]}},{key:"getQueryParameters",value:function(e,t){var n=String(e).split(t),s=n[1],o=String(s).split(this.getCognitoConstants().AMPERSAND),i=o.length,r=new Map,a=void 0;for(a=0;a<i;a++)o[a]=String(o[a]).split(this.getCognitoConstants().QUERYPARAMETERREGEX2),r.set(o[a][0],o[a][1]);return r}},{key:"generateRandomString",value:function(e,t){for(var n="",s=e;s>0;--s)n+=t[Math.round(Math.random()*(t.length-1))];return n}},{key:"clearCachedTokensScopes",value:function(){var e="CognitoIdentityServiceProvider."+this.getClientId(),t=e+"."+this.username+".idToken",n=e+"."+this.username+".accessToken",s=e+"."+this.username+".refreshToken",o=e+".LastAuthUser",i=e+"."+this.username+".tokenScopesString";this.storage.removeItem(t),this.storage.removeItem(n),this.storage.removeItem(s),this.storage.removeItem(o),this.storage.removeItem(i)}},{key:"refreshSession",value:function(e){var t=this.getCognitoConstants().DOMAIN_SCHEME.concat(this.getCognitoConstants().COLONDOUBLESLASH,this.getAppWebDomain(),this.getCognitoConstants().SLASH,this.getCognitoConstants().DOMAIN_PATH_TOKEN),n=this.getCognitoConstants().HEADER,s={grant_type:this.getCognitoConstants().REFRESHTOKEN,client_id:this.getClientId(),redirect_uri:this.RedirectUriSignIn,refresh_token:e},o=this.onSuccessRefreshToken.bind(this),i=this.onFailure.bind(this);this.makePOSTRequest(n,s,t,o,i)}},{key:"makePOSTRequest",value:function(e,t,n,s,o){var i=this.createCORSRequest(this.getCognitoConstants().POST,n),r="";if(i){for(var a in e)i.setRequestHeader(a,e[a]);for(var u in t)r=r.concat(u,this.getCognitoConstants().EQUALSIGN,t[u],this.getCognitoConstants().AMPERSAND);r=r.substring(0,r.length-1),i.send(r),i.onreadystatechange=function(){4===i.readyState&&(200===i.status?s(i.responseText):o(i.responseText))}}}},{key:"createCORSRequest",value:function(e,t){var n=new XMLHttpRequest;return n.open(e,t,!0),this.getCognitoConstants().WITHCREDENTIALS in n?n.open(e,t,!0):("undefined"==typeof XDomainRequest?"undefined":i(XDomainRequest))!==this.getCognitoConstants().UNDEFINED?(n=new XDomainRequest,n.open(e,t)):n=null,n}},{key:"onFailure",value:function(e){this.userhandler.onFailure(e)}},{key:"onSuccessRefreshToken",value:function(e){var t=JSON.parse(e);if(Object.prototype.hasOwnProperty.call(t,this.getCognitoConstants().ERROR)){var n=this.getFQDNSignIn();this.launchUri(n)}else Object.prototype.hasOwnProperty.call(t,this.getCognitoConstants().IDTOKEN)&&this.signInUserSession.setIdToken(new l.default(t.id_token)),Object.prototype.hasOwnProperty.call(t,this.getCognitoConstants().ACCESSTOKEN)&&this.signInUserSession.setAccessToken(new g.default(t.access_token)),this.cacheTokensScopes(),this.userhandler.onSuccess(this.signInUserSession)}},{key:"onSuccessExchangeForToken",value:function(e){var t=JSON.parse(e),n=new d.default,s=new g.default,o=new l.default;return Object.prototype.hasOwnProperty.call(t,this.getCognitoConstants().ERROR)?this.userhandler.onFailure(e):(Object.prototype.hasOwnProperty.call(t,this.getCognitoConstants().IDTOKEN)?this.signInUserSession.setIdToken(new l.default(t.id_token)):this.signInUserSession.setIdToken(o),Object.prototype.hasOwnProperty.call(t,this.getCognitoConstants().ACCESSTOKEN)?this.signInUserSession.setAccessToken(new g.default(t.access_token)):this.signInUserSession.setAccessToken(s),Object.prototype.hasOwnProperty.call(t,this.getCognitoConstants().REFRESHTOKEN)?this.signInUserSession.setRefreshToken(new d.default(t.refresh_token)):this.signInUserSession.setRefreshToken(n),this.cacheTokensScopes(),void this.userhandler.onSuccess(this.signInUserSession))}},{key:"launchUri",value:function(e){window.open(e,this.getCognitoConstants().SELF)}},{key:"getSpaceSeperatedScopeString",value:function(){var e=this.signInUserSession.getTokenScopes().getScopes();return e=e.join(this.getCognitoConstants().SPACE),encodeURIComponent(e)}},{key:"getFQDNSignIn",value:function(){null==this.state&&(this.state=this.generateRandomString(this.getCognitoConstants().STATELENGTH,this.getCognitoConstants().STATEORIGINSTRING));var e=this.IdentityProvider?this.getCognitoConstants().AMPERSAND.concat(this.getCognitoConstants().DOMAIN_QUERY_PARAM_IDENTITY_PROVIDER,this.getCognitoConstants().EQUALSIGN,this.IdentityProvider):"",t=this.getSpaceSeperatedScopeString(),n="",s=this.getUserContextData();s&&(n=this.getCognitoConstants().AMPERSAND+this.getCognitoConstants().DOMAIN_QUERY_PARAM_USERCONTEXTDATA+this.getCognitoConstants().EQUALSIGN+this.getUserContextData());var o=this.getCognitoConstants().DOMAIN_SCHEME.concat(this.getCognitoConstants().COLONDOUBLESLASH,this.getAppWebDomain(),this.getCognitoConstants().SLASH,this.getCognitoConstants().DOMAIN_PATH_SIGNIN,this.getCognitoConstants().QUESTIONMARK,this.getCognitoConstants().DOMAIN_QUERY_PARAM_REDIRECT_URI,this.getCognitoConstants().EQUALSIGN,encodeURIComponent(this.RedirectUriSignIn),this.getCognitoConstants().AMPERSAND,this.getCognitoConstants().DOMAIN_QUERY_PARAM_RESPONSE_TYPE,this.getCognitoConstants().EQUALSIGN,this.responseType,this.getCognitoConstants().AMPERSAND,this.getCognitoConstants().CLIENT_ID,this.getCognitoConstants().EQUALSIGN,this.getClientId(),this.getCognitoConstants().AMPERSAND,this.getCognitoConstants().STATE,this.getCognitoConstants().EQUALSIGN,this.state,this.getCognitoConstants().AMPERSAND,this.getCognitoConstants().SCOPE,this.getCognitoConstants().EQUALSIGN,t,e,n);return o}},{key:"signOut",value:function(){var e=this.getFQDNSignOut();this.signInUserSession=null,this.clearCachedTokensScopes(),this.launchUri(e)}},{key:"getFQDNSignOut",value:function(){var e=this.getCognitoConstants().DOMAIN_SCHEME.concat(this.getCognitoConstants().COLONDOUBLESLASH,this.getAppWebDomain(),this.getCognitoConstants().SLASH,this.getCognitoConstants().DOMAIN_PATH_SIGNOUT,this.getCognitoConstants().QUESTIONMARK,this.getCognitoConstants().DOMAIN_QUERY_PARAM_SIGNOUT_URI,this.getCognitoConstants().EQUALSIGN,encodeURIComponent(this.RedirectUriSignOut),this.getCognitoConstants().AMPERSAND,this.getCognitoConstants().CLIENT_ID,this.getCognitoConstants().EQUALSIGN,this.getClientId());return e}},{key:"getUserContextData",value:function(){if("undefined"!=typeof AmazonCognitoAdvancedSecurityData){var e="";this.username&&(e=this.username);var t="";return this.userpoolId&&(t=this.userpoolId),this.advancedSecurityDataCollectionFlag?AmazonCognitoAdvancedSecurityData.getData(e,t,this.clientId):void 0}}},{key:"isUserSignedIn",value:function(){return null!=this.signInUserSession&&this.signInUserSession.isValid()||null!=this.getCachedSession()&&this.getCachedSession().isValid()}}]),e}();t.default=y},function(e,t){"use strict";function n(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}Object.defineProperty(t,"__esModule",{value:!0});var s=function(){function e(e,t){for(var n=0;n<t.length;n++){var s=t[n];s.enumerable=s.enumerable||!1,s.configurable=!0,"value"in s&&(s.writable=!0),Object.defineProperty(e,s.key,s)}}return function(t,n,s){return n&&e(t.prototype,n),s&&e(t,s),t}}(),o=["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],i=["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],r=function(){function e(){n(this,e)}return s(e,[{key:"getNowString",value:function(){var e=new Date,t=i[e.getUTCDay()],n=o[e.getUTCMonth()],s=e.getUTCDate(),r=e.getUTCHours();r<10&&(r="0"+r);var a=e.getUTCMinutes();a<10&&(a="0"+a);var u=e.getUTCSeconds();u<10&&(u="0"+u);var c=e.getUTCFullYear(),g=t+" "+n+" "+s+" "+r+":"+a+":"+u+" UTC "+c;return g}}]),e}();t.default=r},function(e,t,n){"use strict";function s(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0});var o=n(1);Object.defineProperty(t,"CognitoAccessToken",{enumerable:!0,get:function(){return s(o).default}});var i=n(2);Object.defineProperty(t,"CognitoIdToken",{enumerable:!0,get:function(){return s(i).default}});var r=n(3);Object.defineProperty(t,"CognitoRefreshToken",{enumerable:!0,get:function(){return s(r).default}});var a=n(4);Object.defineProperty(t,"CognitoTokenScopes",{enumerable:!0,get:function(){return s(a).default}});var u=n(7);Object.defineProperty(t,"CognitoAuth",{enumerable:!0,get:function(){return s(u).default}});var c=n(5);Object.defineProperty(t,"CognitoAuthSession",{enumerable:!0,get:function(){return s(c).default}});var g=n(8);Object.defineProperty(t,"DateHelper",{enumerable:!0,get:function(){return s(g).default}});var h=n(6);Object.defineProperty(t,"StorageHelper",{enumerable:!0,get:function(){return s(h).default}})}])});
//# sourceMappingURL=amazon-cognito-auth.min.js.map