/*!
 * Copyright 2016 Amazon.com,
 * Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Amazon Software License (the "License").
 * You may not use this file except in compliance with the
 * License. A copy of the License is located at
 * 
 *     http://aws.amazon.com/asl/
 * 
 * or in the "license" file accompanying this file. This file is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, express or implied. See the License
 * for the specific language governing permissions and
 * limitations under the License. 
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t(require("sjcl"),require("aws-sdk/clients/cognitoidentityserviceprovider"),require("jsbn")):"function"==typeof define&&define.amd?define(["sjcl","aws-sdk/clients/cognitoidentityserviceprovider","jsbn"],t):"object"==typeof exports?exports.AmazonCognitoIdentity=t(require("sjcl"),require("aws-sdk/clients/cognitoidentityserviceprovider"),require("jsbn")):e.AmazonCognitoIdentity=t(e.sjcl,e.AWSCognito.CognitoIdentityServiceProvider,e)}(this,function(e,t,n){return function(e){function t(i){if(n[i])return n[i].exports;var s=n[i]={exports:{},id:i,loaded:!1};return e[i].call(s.exports,s,s.exports,t),s.loaded=!0,s.exports}var n={};return t.m=e,t.c=n,t.p="",t(0)}([function(e,t,n){"use strict";function i(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&(t[n]=e[n]);return t["default"]=e,t}function s(e){return e&&e.__esModule?e:{"default":e}}Object.defineProperty(t,"__esModule",{value:!0});var r=n(14);Object.keys(r).forEach(function(e){"default"!==e&&"__esModule"!==e&&Object.defineProperty(t,e,{enumerable:!0,get:function(){return r[e]}})});var o=n(10),a=s(o),u=i(r);Object.keys(u).forEach(function(e){a["default"][e]=u[e]})},function(t,n){t.exports=e},function(e,t,n){"use strict";function i(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&(t[n]=e[n]);return t["default"]=e,t}function s(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}Object.defineProperty(t,"__esModule",{value:!0});var r=function(){function e(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}return function(t,n,i){return n&&e(t.prototype,n),i&&e(t,i),t}}(),o=n(1),a=i(o),u=n(11),c="FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA18217C32905E462E36CE3BE39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9DE2BCBF6955817183995497CEA956AE515D2261898FA051015728E5A8AAAC42DAD33170D04507A33A85521ABDF1CBA64ECFB850458DBEF0A8AEA71575D060C7DB3970F85A6E1E4C7ABF5AE8CDB0933D71E8C94E04A25619DCEE3D2261AD2EE6BF12FFA06D98A0864D87602733EC86A64521F2B18177B200CBBE117577A615D6C770988C0BAD946E208E24FA074E5AB3143DB5BFCE0FD108E4B82D120A93AD2CAFFFFFFFFFFFFFFFF",l="userAttributes.",h=function(){function e(t,n){s(this,e),this.N=new u.BigInteger(c,16),this.g=new u.BigInteger("2"),this.k=new u.BigInteger(this.hexHash("00"+this.N.toString(16)+"0"+this.g.toString(16)),16),this.paranoia=n,this.smallAValue=this.generateRandomSmallA(),this.largeAValue=this.calculateA(this.smallAValue),this.infoBits=a.codec.utf8String.toBits("Caldera Derived Key"),this.poolName=t}return r(e,[{key:"getSmallAValue",value:function(){return this.smallAValue}},{key:"getLargeAValue",value:function(){return this.largeAValue}},{key:"generateRandomSmallA",value:function(){var e=a.random.randomWords(32,this.paranoia),t=a.codec.hex.fromBits(e),n=new u.BigInteger(t,16),i=n.mod(this.N);return i}},{key:"generateRandomString",value:function(){var e=a.random.randomWords(10,this.paranoia),t=a.codec.base64.fromBits(e);return t}},{key:"getRandomPassword",value:function(){return this.randomPassword}},{key:"getSaltDevices",value:function(){return this.SaltToHashDevices}},{key:"getVerifierDevices",value:function(){return this.verifierDevices}},{key:"generateHashDevice",value:function(e,t){this.randomPassword=this.generateRandomString();var n=""+e+t+":"+this.randomPassword,i=this.hash(n),s=a.random.randomWords(4,this.paranoia),r=a.codec.hex.fromBits(s),o=new u.BigInteger(r,16),c=o.toString(16)[0];this.SaltToHashDevices=o.toString(16),o.toString(16).length%2===1?this.SaltToHashDevices="0"+this.SaltToHashDevices:"89ABCDEFabcdef".indexOf(c)!==-1&&(this.SaltToHashDevices="00"+this.SaltToHashDevices);var l=this.g.modPow(new u.BigInteger(this.hexHash(this.SaltToHashDevices+i),16),this.N),h=l.toString(16)[0];this.verifierDevices=l.toString(16),l.toString(16).length%2===1?this.verifierDevices="0"+this.verifierDevices:"89ABCDEFabcdef".indexOf(h)!==-1&&(this.verifierDevices="00"+this.verifierDevices)}},{key:"calculateA",value:function(e){var t=this.g.modPow(e,this.N);if("0"===t.mod(this.N).toString())throw new Error("Illegal paramater. A mod N cannot be 0.");return t}},{key:"calculateU",value:function(e,t){var n=e.toString(16)[0],i=t.toString(16)[0],s=e.toString(16),r=t.toString(16);e.toString(16).length%2===1?s="0"+s:"89ABCDEFabcdef".indexOf(n)!==-1&&(s="00"+s),t.toString(16).length%2===1?r="0"+r:"89ABCDEFabcdef".indexOf(i)!==-1&&(r="00"+r),this.UHexHash=this.hexHash(s+r);var o=new u.BigInteger(this.UHexHash,16);return o}},{key:"hash",value:function(e){var t=a.codec.hex.fromBits(a.hash.sha256.hash(e));return new Array(64-t.length).join("0")+t}},{key:"hexHash",value:function(e){var t=a.codec.hex.fromBits(a.hash.sha256.hash(a.codec.hex.toBits(e)));return new Array(64-t.length).join("0")+t}},{key:"computehkdf",value:function(e,t){var n=new a.misc.hmac(t,a.hash.sha256);n.update(e);var i=n.digest(),s=new a.misc.hmac(i,a.hash.sha256),r=a.bitArray.concat(this.infoBits,a.codec.utf8String.toBits(String.fromCharCode(1)));return s.update(r),a.bitArray.clamp(s.digest(),128)}},{key:"getPasswordAuthenticationKey",value:function(e,t,n,i){if(n.mod(this.N).equals(new u.BigInteger("0",16)))throw new Error("B cannot be zero.");if(this.UValue=this.calculateU(this.largeAValue,n),this.UValue.equals(new u.BigInteger("0",16)))throw new Error("U cannot be zero.");var s=""+this.poolName+e+":"+t,r=this.hash(s),o=i.toString(16)[0],c=i.toString(16);i.toString(16).length%2===1?c="0"+c:"89ABCDEFabcdef".indexOf(o)!==-1&&(c="00"+c);var l=new u.BigInteger(this.hexHash(c+r),16),h=this.g.modPow(l,this.N),d=n.subtract(this.k.multiply(h)),f=d.modPow(this.smallAValue.add(this.UValue.multiply(l)),this.N).mod(this.N),g=f.toString(16),v=f.toString(16)[0];f.toString(16).length%2===1?g="0"+g:"89ABCDEFabcdef".indexOf(v)!==-1&&(g="00"+g);var S=this.UHexHash,m=this.UHexHash[0];this.UHexHash.length%2===1?S="0"+S:this.UHexHash.length%2===0&&"89ABCDEFabcdef".indexOf(m)!==-1&&(S="00"+S);var C=this.computehkdf(a.codec.hex.toBits(g),a.codec.hex.toBits(S));return C}},{key:"getNewPasswordRequiredChallengeUserAttributePrefix",value:function(){return l}}]),e}();t["default"]=h},function(e,t,n){"use strict";function i(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&(t[n]=e[n]);return t["default"]=e,t}function s(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}Object.defineProperty(t,"__esModule",{value:!0});var r=function(){function e(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}return function(t,n,i){return n&&e(t.prototype,n),i&&e(t,i),t}}(),o=n(1),a=i(o),u=function(){function e(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},n=t.AccessToken;s(this,e),this.jwtToken=n||""}return r(e,[{key:"getJwtToken",value:function(){return this.jwtToken}},{key:"getExpiration",value:function(){var e=this.jwtToken.split(".")[1],t=JSON.parse(a.codec.utf8String.fromBits(a.codec.base64url.toBits(e)));return t.exp}}]),e}();t["default"]=u},function(e,t,n){"use strict";function i(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&(t[n]=e[n]);return t["default"]=e,t}function s(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}Object.defineProperty(t,"__esModule",{value:!0});var r=function(){function e(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}return function(t,n,i){return n&&e(t.prototype,n),i&&e(t,i),t}}(),o=n(1),a=i(o),u=function(){function e(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},n=t.IdToken;s(this,e),this.jwtToken=n||""}return r(e,[{key:"getJwtToken",value:function(){return this.jwtToken}},{key:"getExpiration",value:function(){var e=this.jwtToken.split(".")[1],t=JSON.parse(a.codec.utf8String.fromBits(a.codec.base64url.toBits(e)));return t.exp}}]),e}();t["default"]=u},function(e,t){"use strict";function n(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}Object.defineProperty(t,"__esModule",{value:!0});var i=function(){function e(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}return function(t,n,i){return n&&e(t.prototype,n),i&&e(t,i),t}}(),s=function(){function e(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},i=t.RefreshToken;n(this,e),this.token=i||""}return i(e,[{key:"getToken",value:function(){return this.token}}]),e}();t["default"]=s},function(e,t,n){"use strict";function i(e){return e&&e.__esModule?e:{"default":e}}function s(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&(t[n]=e[n]);return t["default"]=e,t}function r(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}Object.defineProperty(t,"__esModule",{value:!0});var o=function(){function e(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}return function(t,n,i){return n&&e(t.prototype,n),i&&e(t,i),t}}(),a=n(1),u=s(a),c=n(11),l=n(2),h=i(l),d=n(3),f=i(d),g=n(4),v=i(g),S=n(5),m=i(S),C=n(8),y=i(C),k=n(9),A=i(k),U=n(7),w=i(U),p=function(){function e(t){if(r(this,e),null==t||null==t.Username||null==t.Pool)throw new Error("Username and pool information are required.");this.username=t.Username||"",this.pool=t.Pool,this.Session=null,this.client=t.Pool.client,this.signInUserSession=null,this.authenticationFlowType="USER_SRP_AUTH"}return o(e,[{key:"getSignInUserSession",value:function(){return this.signInUserSession}},{key:"getUsername",value:function(){return this.username}},{key:"getAuthenticationFlowType",value:function(){return this.authenticationFlowType}},{key:"setAuthenticationFlowType",value:function(e){this.authenticationFlowType=e}},{key:"authenticateUser",value:function(e,t){var n=this,i=new h["default"](this.pool.getUserPoolId().split("_")[1],this.pool.getParanoia()),s=new A["default"],r=void 0,o=void 0,a={};null!=this.deviceKey&&(a.DEVICE_KEY=this.deviceKey),a.USERNAME=this.username,a.SRP_A=i.getLargeAValue().toString(16),"CUSTOM_AUTH"===this.authenticationFlowType&&(a.CHALLENGE_NAME="SRP_A"),this.client.makeUnauthenticatedRequest("initiateAuth",{AuthFlow:this.authenticationFlowType,ClientId:this.pool.getClientId(),AuthParameters:a,ClientMetadata:e.getValidationData()},function(a,l){if(a)return t.onFailure(a);var h=l.ChallengeParameters;n.username=h.USER_ID_FOR_SRP,r=new c.BigInteger(h.SRP_B,16),o=new c.BigInteger(h.SALT,16),n.getCachedDeviceKeyAndPassword();var d=i.getPasswordAuthenticationKey(n.username,e.getPassword(),r,o),f=u.codec.base64.toBits(h.SECRET_BLOCK),g=new u.misc.hmac(d,u.hash.sha256);g.update(u.codec.utf8String.toBits(n.pool.getUserPoolId().split("_")[1])),g.update(u.codec.utf8String.toBits(n.username)),g.update(f);var v=s.getNowString();g.update(u.codec.utf8String.toBits(v));var S=g.digest(),m=u.codec.base64.fromBits(S),C={};C.USERNAME=n.username,C.PASSWORD_CLAIM_SECRET_BLOCK=h.SECRET_BLOCK,C.TIMESTAMP=v,C.PASSWORD_CLAIM_SIGNATURE=m,null!=n.deviceKey&&(C.DEVICE_KEY=n.deviceKey),n.client.makeUnauthenticatedRequest("respondToAuthChallenge",{ChallengeName:"PASSWORD_VERIFIER",ClientId:n.pool.getClientId(),ChallengeResponses:C,Session:l.Session},function(e,s){if(e)return t.onFailure(e);var r=s.ChallengeName;if("NEW_PASSWORD_REQUIRED"===r){n.Session=s.Session;var o=null,a=null,u=[],c=i.getNewPasswordRequiredChallengeUserAttributePrefix();if(s.ChallengeParameters&&(o=JSON.parse(s.ChallengeParameters.userAttributes),a=JSON.parse(s.ChallengeParameters.requiredAttributes)),a)for(var l=0;l<a.length;l++)u[l]=a[l].substr(c.length);return t.newPasswordRequired(o,u)}return n.authenticateUserInternal(s,i,t)})})}},{key:"authenticateUserInternal",value:function(e,t,n){var i=this,s=e.ChallengeName;if("SMS_MFA"===s)return this.Session=e.Session,n.mfaRequired(s);if("CUSTOM_CHALLENGE"===s)return this.Session=e.Session,n.customChallenge(e.ChallengeParameters);if("DEVICE_SRP_AUTH"===s)return void this.getDeviceResponse(n);this.signInUserSession=this.getCognitoUserSession(e.AuthenticationResult),this.cacheTokens();var r=e.AuthenticationResult.NewDeviceMetadata;if(null==r)return n.onSuccess(this.signInUserSession);t.generateHashDevice(e.AuthenticationResult.NewDeviceMetadata.DeviceGroupKey,e.AuthenticationResult.NewDeviceMetadata.DeviceKey);var o={Salt:u.codec.base64.fromBits(u.codec.hex.toBits(t.getSaltDevices().toString(16))),PasswordVerifier:u.codec.base64.fromBits(u.codec.hex.toBits(t.getVerifierDevices().toString(16)))};this.verifierDevices=u.codec.base64.fromBits(t.getVerifierDevices()),this.deviceGroupKey=r.DeviceGroupKey,this.randomPassword=t.getRandomPassword(),this.client.makeUnauthenticatedRequest("confirmDevice",{DeviceKey:r.DeviceKey,AccessToken:this.signInUserSession.getAccessToken().getJwtToken(),DeviceSecretVerifierConfig:o,DeviceName:navigator.userAgent},function(t,s){return t?n.onFailure(t):(i.deviceKey=e.AuthenticationResult.NewDeviceMetadata.DeviceKey,i.cacheDeviceKeyAndPassword(),s.UserConfirmationNecessary===!0?n.onSuccess(i.signInUserSession,s.UserConfirmationNecessary):n.onSuccess(i.signInUserSession))})}},{key:"completeNewPasswordChallenge",value:function(e,t,n){var i=this;if(!e)return n.onFailure("New password is required.");var s=new h["default"](this.pool.getUserPoolId().split("_")[1],this.pool.getParanoia()),r=s.getNewPasswordRequiredChallengeUserAttributePrefix(),o={};t&&Object.keys(t).forEach(function(e){o[r+e]=t[e]}),o.NEW_PASSWORD=e,o.USERNAME=this.username,this.client.makeUnauthenticatedRequest("respondToAuthChallenge",{ChallengeName:"NEW_PASSWORD_REQUIRED",ClientId:this.pool.getClientId(),ChallengeResponses:o,Session:this.Session},function(e,t){return e?n.onFailure(e):i.authenticateUserInternal(t,s,n)})}},{key:"getDeviceResponse",value:function(e){var t=this,n=new h["default"](this.deviceGroupKey,this.pool.getParanoia()),i=new A["default"],s={};s.USERNAME=this.username,s.DEVICE_KEY=this.deviceKey,s.SRP_A=n.getLargeAValue().toString(16),this.client.makeUnauthenticatedRequest("respondToAuthChallenge",{ChallengeName:"DEVICE_SRP_AUTH",ClientId:this.pool.getClientId(),ChallengeResponses:s},function(s,r){if(s)return e.onFailure(s);var o=r.ChallengeParameters,a=new c.BigInteger(o.SRP_B,16),l=new c.BigInteger(o.SALT,16),h=n.getPasswordAuthenticationKey(t.deviceKey,t.randomPassword,a,l),d=u.codec.base64.toBits(o.SECRET_BLOCK),f=new u.misc.hmac(h,u.hash.sha256);f.update(u.codec.utf8String.toBits(t.deviceGroupKey)),f.update(u.codec.utf8String.toBits(t.deviceKey)),f.update(d);var g=i.getNowString();f.update(u.codec.utf8String.toBits(g));var v=f.digest(),S=u.codec.base64.fromBits(v),m={};m.USERNAME=t.username,m.PASSWORD_CLAIM_SECRET_BLOCK=o.SECRET_BLOCK,m.TIMESTAMP=g,m.PASSWORD_CLAIM_SIGNATURE=S,m.DEVICE_KEY=t.deviceKey,t.client.makeUnauthenticatedRequest("respondToAuthChallenge",{ChallengeName:"DEVICE_PASSWORD_VERIFIER",ClientId:t.pool.getClientId(),ChallengeResponses:m,Session:r.Session},function(n,i){return n?e.onFailure(n):(t.signInUserSession=t.getCognitoUserSession(i.AuthenticationResult),t.cacheTokens(),e.onSuccess(t.signInUserSession))})})}},{key:"confirmRegistration",value:function(e,t,n){this.client.makeUnauthenticatedRequest("confirmSignUp",{ClientId:this.pool.getClientId(),ConfirmationCode:e,Username:this.username,ForceAliasCreation:t},function(e){return e?n(e,null):n(null,"SUCCESS")})}},{key:"sendCustomChallengeAnswer",value:function(e,t){var n=this,i={};i.USERNAME=this.username,i.ANSWER=e,this.client.makeUnauthenticatedRequest("respondToAuthChallenge",{ChallengeName:"CUSTOM_CHALLENGE",ChallengeResponses:i,ClientId:this.pool.getClientId(),Session:this.Session},function(e,i){if(e)return t.onFailure(e);var s=i.ChallengeName;return"CUSTOM_CHALLENGE"===s?(n.Session=i.Session,t.customChallenge(i.challengeParameters)):(n.signInUserSession=n.getCognitoUserSession(i.AuthenticationResult),n.cacheTokens(),t.onSuccess(n.signInUserSession))})}},{key:"sendMFACode",value:function(e,t){var n=this,i={};i.USERNAME=this.username,i.SMS_MFA_CODE=e,null!=this.deviceKey&&(i.DEVICE_KEY=this.deviceKey),this.client.makeUnauthenticatedRequest("respondToAuthChallenge",{ChallengeName:"SMS_MFA",ChallengeResponses:i,ClientId:this.pool.getClientId(),Session:this.Session},function(e,i){if(e)return t.onFailure(e);if(n.signInUserSession=n.getCognitoUserSession(i.AuthenticationResult),n.cacheTokens(),null==i.AuthenticationResult.NewDeviceMetadata)return t.onSuccess(n.signInUserSession);var s=new h["default"](n.pool.getUserPoolId().split("_")[1],n.pool.getParanoia());s.generateHashDevice(i.AuthenticationResult.NewDeviceMetadata.DeviceGroupKey,i.AuthenticationResult.NewDeviceMetadata.DeviceKey);var r={Salt:u.codec.base64.fromBits(u.codec.hex.toBits(s.getSaltDevices().toString(16))),PasswordVerifier:u.codec.base64.fromBits(u.codec.hex.toBits(s.getVerifierDevices().toString(16)))};n.verifierDevices=u.codec.base64.fromBits(s.getVerifierDevices()),n.deviceGroupKey=i.AuthenticationResult.NewDeviceMetadata.DeviceGroupKey,n.randomPassword=s.getRandomPassword(),n.client.makeUnauthenticatedRequest("confirmDevice",{DeviceKey:i.AuthenticationResult.NewDeviceMetadata.DeviceKey,AccessToken:n.signInUserSession.getAccessToken().getJwtToken(),DeviceSecretVerifierConfig:r,DeviceName:navigator.userAgent},function(e,s){return e?t.onFailure(e):(n.deviceKey=i.AuthenticationResult.NewDeviceMetadata.DeviceKey,n.cacheDeviceKeyAndPassword(),s.UserConfirmationNecessary===!0?t.onSuccess(n.signInUserSession,s.UserConfirmationNecessary):t.onSuccess(n.signInUserSession))})})}},{key:"changePassword",value:function(e,t,n){return null!=this.signInUserSession&&this.signInUserSession.isValid()?void this.client.makeUnauthenticatedRequest("changePassword",{PreviousPassword:e,ProposedPassword:t,AccessToken:this.signInUserSession.getAccessToken().getJwtToken()},function(e){return e?n(e,null):n(null,"SUCCESS")}):n(new Error("User is not authenticated"),null)}},{key:"enableMFA",value:function(e){if(null==this.signInUserSession||!this.signInUserSession.isValid())return e(new Error("User is not authenticated"),null);var t=[],n={DeliveryMedium:"SMS",AttributeName:"phone_number"};t.push(n),this.client.makeUnauthenticatedRequest("setUserSettings",{MFAOptions:t,AccessToken:this.signInUserSession.getAccessToken().getJwtToken()},function(t){return t?e(t,null):e(null,"SUCCESS")})}},{key:"disableMFA",value:function(e){if(null==this.signInUserSession||!this.signInUserSession.isValid())return e(new Error("User is not authenticated"),null);var t=[];this.client.makeUnauthenticatedRequest("setUserSettings",{MFAOptions:t,AccessToken:this.signInUserSession.getAccessToken().getJwtToken()},function(t){return t?e(t,null):e(null,"SUCCESS")})}},{key:"deleteUser",value:function(e){return null!=this.signInUserSession&&this.signInUserSession.isValid()?void this.client.makeUnauthenticatedRequest("deleteUser",{AccessToken:this.signInUserSession.getAccessToken().getJwtToken()},function(t){return t?e(t,null):e(null,"SUCCESS")}):e(new Error("User is not authenticated"),null)}},{key:"updateAttributes",value:function(e,t){return null!=this.signInUserSession&&this.signInUserSession.isValid()?void this.client.makeUnauthenticatedRequest("updateUserAttributes",{AccessToken:this.signInUserSession.getAccessToken().getJwtToken(),UserAttributes:e},function(e){return e?t(e,null):t(null,"SUCCESS")}):t(new Error("User is not authenticated"),null)}},{key:"getUserAttributes",value:function(e){return null!=this.signInUserSession&&this.signInUserSession.isValid()?void this.client.makeUnauthenticatedRequest("getUser",{AccessToken:this.signInUserSession.getAccessToken().getJwtToken()},function(t,n){if(t)return e(t,null);for(var i=[],s=0;s<n.UserAttributes.length;s++){var r={Name:n.UserAttributes[s].Name,Value:n.UserAttributes[s].Value},o=new w["default"](r);i.push(o)}return e(null,i)}):e(new Error("User is not authenticated"),null)}},{key:"deleteAttributes",value:function(e,t){return null!=this.signInUserSession&&this.signInUserSession.isValid()?void this.client.makeUnauthenticatedRequest("deleteUserAttributes",{UserAttributeNames:e,AccessToken:this.signInUserSession.getAccessToken().getJwtToken()},function(e){return e?t(e,null):t(null,"SUCCESS")}):t(new Error("User is not authenticated"),null)}},{key:"resendConfirmationCode",value:function(e){this.client.makeUnauthenticatedRequest("resendConfirmationCode",{ClientId:this.pool.getClientId(),Username:this.username},function(t){return t?e(t,null):e(null,"SUCCESS")})}},{key:"getSession",value:function(e){if(null==this.username)return e(new Error("Username is null. Cannot retrieve a new session"),null);if(null!=this.signInUserSession&&this.signInUserSession.isValid())return e(null,this.signInUserSession);var t="CognitoIdentityServiceProvider."+this.pool.getClientId()+"."+this.username,n=t+".idToken",i=t+".accessToken",s=t+".refreshToken",r=window.localStorage;if(r.getItem(n)){var o=new v["default"]({IdToken:r.getItem(n)}),a=new f["default"]({AccessToken:r.getItem(i)}),u=new m["default"]({RefreshToken:r.getItem(s)}),c={IdToken:o,AccessToken:a,RefreshToken:u},l=new y["default"](c);if(l.isValid())return this.signInUserSession=l,e(null,this.signInUserSession);if(null==u.getToken())return e(new Error("Cannot retrieve a new session. Please authenticate."),null);this.refreshSession(u,e)}}},{key:"refreshSession",value:function(e,t){var n=this,i={};i.REFRESH_TOKEN=e.getToken();var s="CognitoIdentityServiceProvider."+this.pool.getClientId(),r=s+".LastAuthUser",o=window.localStorage;if(o.getItem(r)){this.username=o.getItem(r);var a=s+"."+this.username+".deviceKey";this.deviceKey=o.getItem(a),i.DEVICE_KEY=this.deviceKey}this.client.makeUnauthenticatedRequest("initiateAuth",{ClientId:this.pool.getClientId(),AuthFlow:"REFRESH_TOKEN_AUTH",AuthParameters:i},function(i,s){if(i)return t(i,null);if(s){var r=s.AuthenticationResult;return Object.prototype.hasOwnProperty.call(r,"RefreshToken")||(r.RefreshToken=e.getToken()),n.signInUserSession=n.getCognitoUserSession(r),n.cacheTokens(),t(null,n.signInUserSession)}})}},{key:"cacheTokens",value:function(){var e="CognitoIdentityServiceProvider."+this.pool.getClientId(),t=e+"."+this.username+".idToken",n=e+"."+this.username+".accessToken",i=e+"."+this.username+".refreshToken",s=e+".LastAuthUser",r=window.localStorage;r.setItem(t,this.signInUserSession.getIdToken().getJwtToken()),r.setItem(n,this.signInUserSession.getAccessToken().getJwtToken()),r.setItem(i,this.signInUserSession.getRefreshToken().getToken()),r.setItem(s,this.username)}},{key:"cacheDeviceKeyAndPassword",value:function(){var e="CognitoIdentityServiceProvider."+this.pool.getClientId()+"."+this.username,t=e+".deviceKey",n=e+".randomPasswordKey",i=e+".deviceGroupKey",s=window.localStorage;s.setItem(t,this.deviceKey),s.setItem(n,this.randomPassword),s.setItem(i,this.deviceGroupKey)}},{key:"getCachedDeviceKeyAndPassword",value:function(){var e="CognitoIdentityServiceProvider."+this.pool.getClientId()+"."+this.username,t=e+".deviceKey",n=e+".randomPasswordKey",i=e+".deviceGroupKey",s=window.localStorage;s.getItem(t)&&(this.deviceKey=s.getItem(t),this.randomPassword=s.getItem(n),this.deviceGroupKey=s.getItem(i))}},{key:"clearCachedDeviceKeyAndPassword",value:function(){var e="CognitoIdentityServiceProvider."+this.pool.getClientId()+"."+this.username,t=e+".deviceKey",n=e+".randomPasswordKey",i=e+".deviceGroupKey",s=window.localStorage;s.removeItem(t),s.removeItem(n),s.removeItem(i)}},{key:"clearCachedTokens",value:function(){var e="CognitoIdentityServiceProvider."+this.pool.getClientId(),t=e+"."+this.username+".idToken",n=e+"."+this.username+".accessToken",i=e+"."+this.username+".refreshToken",s=e+".LastAuthUser",r=window.localStorage;r.removeItem(t),r.removeItem(n),r.removeItem(i),r.removeItem(s)}},{key:"getCognitoUserSession",value:function(e){var t=new v["default"](e),n=new f["default"](e),i=new m["default"](e),s={IdToken:t,AccessToken:n,RefreshToken:i};return new y["default"](s)}},{key:"forgotPassword",value:function(e){this.client.makeUnauthenticatedRequest("forgotPassword",{ClientId:this.pool.getClientId(),Username:this.username},function(t,n){return t?e.onFailure(t):"function"==typeof e.inputVerificationCode?e.inputVerificationCode(n):e.onSuccess()})}},{key:"confirmPassword",value:function(e,t,n){this.client.makeUnauthenticatedRequest("confirmForgotPassword",{ClientId:this.pool.getClientId(),Username:this.username,ConfirmationCode:e,Password:t},function(e){return e?n.onFailure(e):n.onSuccess()})}},{key:"getAttributeVerificationCode",value:function(e,t){return null!=this.signInUserSession&&this.signInUserSession.isValid()?void this.client.makeUnauthenticatedRequest("getUserAttributeVerificationCode",{AttributeName:e,AccessToken:this.signInUserSession.getAccessToken().getJwtToken()},function(e,n){return e?t.onFailure(e):t.inputVerificationCode(n)}):t(new Error("User is not authenticated"),null)}},{key:"verifyAttribute",value:function(e,t,n){return null!=this.signInUserSession&&this.signInUserSession.isValid()?void this.client.makeUnauthenticatedRequest("verifyUserAttribute",{AttributeName:e,Code:t,AccessToken:this.signInUserSession.getAccessToken().getJwtToken()},function(e){return e?n.onFailure(e):n.onSuccess("SUCCESS")}):n(new Error("User is not authenticated"),null)}},{key:"getDevice",value:function(e){return null!=this.signInUserSession&&this.signInUserSession.isValid()?void this.client.makeUnauthenticatedRequest("getDevice",{AccessToken:this.signInUserSession.getAccessToken().getJwtToken(),DeviceKey:this.deviceKey},function(t,n){return t?e.onFailure(t):e.onSuccess(n)}):e(new Error("User is not authenticated"),null)}},{key:"forgetDevice",value:function(e){var t=this;return null!=this.signInUserSession&&this.signInUserSession.isValid()?void this.client.makeUnauthenticatedRequest("forgetDevice",{AccessToken:this.signInUserSession.getAccessToken().getJwtToken(),DeviceKey:this.deviceKey},function(n){return n?e.onFailure(n):(t.deviceKey=null,t.deviceGroupkey=null,t.randomPassword=null,t.clearCachedDeviceKeyAndPassword(),e.onSuccess("SUCCESS"))}):e(new Error("User is not authenticated"),null)}},{key:"setDeviceStatusRemembered",value:function(e){return null!=this.signInUserSession&&this.signInUserSession.isValid()?void this.client.makeUnauthenticatedRequest("updateDeviceStatus",{AccessToken:this.signInUserSession.getAccessToken().getJwtToken(),DeviceKey:this.deviceKey,DeviceRememberedStatus:"remembered"},function(t){return t?e.onFailure(t):e.onSuccess("SUCCESS")}):e(new Error("User is not authenticated"),null)}},{key:"setDeviceStatusNotRemembered",value:function(e){return null!=this.signInUserSession&&this.signInUserSession.isValid()?void this.client.makeUnauthenticatedRequest("updateDeviceStatus",{AccessToken:this.signInUserSession.getAccessToken().getJwtToken(),DeviceKey:this.deviceKey,DeviceRememberedStatus:"not_remembered"},function(t){return t?e.onFailure(t):e.onSuccess("SUCCESS")}):e(new Error("User is not authenticated"),null)}},{key:"listDevices",value:function(e,t,n){return null!=this.signInUserSession&&this.signInUserSession.isValid()?void this.client.makeUnauthenticatedRequest("listDevices",{AccessToken:this.signInUserSession.getAccessToken().getJwtToken(),Limit:e,PaginationToken:t},function(e,t){return e?n.onFailure(e):n.onSuccess(t)}):n(new Error("User is not authenticated"),null)}},{key:"globalSignOut",value:function(e){var t=this;return null!=this.signInUserSession&&this.signInUserSession.isValid()?void this.client.makeUnauthenticatedRequest("globalSignOut",{AccessToken:this.signInUserSession.getAccessToken().getJwtToken()},function(n){return n?e.onFailure(n):(t.clearCachedTokens(),e.onSuccess("SUCCESS"))}):e(new Error("User is not authenticated"),null)}},{key:"signOut",value:function(){this.signInUserSession=null,this.clearCachedTokens()}}]),e}();t["default"]=p},function(e,t){"use strict";function n(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}Object.defineProperty(t,"__esModule",{value:!0});var i=function(){function e(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}return function(t,n,i){return n&&e(t.prototype,n),i&&e(t,i),t}}(),s=function(){function e(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},i=t.Name,s=t.Value;n(this,e),this.Name=i||"",this.Value=s||""}return i(e,[{key:"getValue",value:function(){return this.Value}},{key:"setValue",value:function(e){return this.Value=e,this}},{key:"getName",value:function(){return this.Name}},{key:"setName",value:function(e){return this.Name=e,this}},{key:"toString",value:function(){return JSON.stringify(this)}},{key:"toJSON",value:function(){return{Name:this.Name,Value:this.Value}}}]),e}();t["default"]=s},function(e,t){"use strict";function n(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}Object.defineProperty(t,"__esModule",{value:!0});var i=function(){function e(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}return function(t,n,i){return n&&e(t.prototype,n),i&&e(t,i),t}}(),s=function(){function e(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},i=t.IdToken,s=t.RefreshToken,r=t.AccessToken;if(n(this,e),null==r||null==i)throw new Error("Id token and Access Token must be present.");this.idToken=i,this.refreshToken=s,this.accessToken=r}return i(e,[{key:"getIdToken",value:function(){return this.idToken}},{key:"getRefreshToken",value:function(){return this.refreshToken}},{key:"getAccessToken",value:function(){return this.accessToken}},{key:"isValid",value:function(){var e=Math.floor(new Date/1e3);return e<this.accessToken.getExpiration()&&e<this.idToken.getExpiration()}}]),e}();t["default"]=s},function(e,t){"use strict";function n(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}Object.defineProperty(t,"__esModule",{value:!0});var i=function(){function e(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}return function(t,n,i){return n&&e(t.prototype,n),i&&e(t,i),t}}(),s=["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],r=["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],o=function(){function e(){n(this,e)}return i(e,[{key:"getNowString",value:function(){var e=new Date,t=r[e.getUTCDay()],n=s[e.getUTCMonth()],i=e.getUTCDate(),o=e.getUTCHours();o<10&&(o="0"+o);var a=e.getUTCMinutes();a<10&&(a="0"+a);var u=e.getUTCSeconds();u<10&&(u="0"+u);var c=e.getUTCFullYear(),l=t+" "+n+" "+i+" "+o+":"+a+":"+u+" UTC "+c;return l}}]),e}();t["default"]=o},function(e,n){e.exports=t},function(e,t){e.exports=n},function(e,t){"use strict";function n(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}Object.defineProperty(t,"__esModule",{value:!0});var i=function(){function e(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}return function(t,n,i){
return n&&e(t.prototype,n),i&&e(t,i),t}}(),s=function(){function e(t){n(this,e);var i=t||{},s=i.ValidationData,r=i.Username,o=i.Password;this.validationData=s||[],this.username=r,this.password=o}return i(e,[{key:"getUsername",value:function(){return this.username}},{key:"getPassword",value:function(){return this.password}},{key:"getValidationData",value:function(){return this.validationData}}]),e}();t["default"]=s},function(e,t,n){"use strict";function i(e){return e&&e.__esModule?e:{"default":e}}function s(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}Object.defineProperty(t,"__esModule",{value:!0});var r=function(){function e(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}return function(t,n,i){return n&&e(t.prototype,n),i&&e(t,i),t}}(),o=n(10),a=i(o),u=n(6),c=i(u),l=function(){function e(t){s(this,e);var n=t||{},i=n.UserPoolId,r=n.ClientId,o=n.Paranoia;if(!i||!r)throw new Error("Both UserPoolId and ClientId are required.");if(!/^[\w-]+_.+$/.test(i))throw new Error("Invalid UserPoolId format.");var u=i.split("_")[0];this.userPoolId=i,this.clientId=r,this.paranoia=o||0,this.client=new a["default"]({apiVersion:"2016-04-19",region:u})}return r(e,[{key:"getUserPoolId",value:function(){return this.userPoolId}},{key:"getClientId",value:function(){return this.clientId}},{key:"getParanoia",value:function(){return this.paranoia}},{key:"setParanoia",value:function(e){this.paranoia=e}},{key:"signUp",value:function(e,t,n,i,s){var r=this;this.client.makeUnauthenticatedRequest("signUp",{ClientId:this.clientId,Username:e,Password:t,UserAttributes:n,ValidationData:i},function(t,n){if(t)return s(t,null);var i={Username:e,Pool:r},o={user:new c["default"](i),userConfirmed:n.UserConfirmed};return s(null,o)})}},{key:"getCurrentUser",value:function(){var e="CognitoIdentityServiceProvider."+this.clientId+".LastAuthUser",t=window.localStorage,n=t.getItem(e);if(n){var i={Username:n,Pool:this};return new c["default"](i)}return null}}]),e}();t["default"]=l},function(e,t,n){"use strict";function i(e){return e&&e.__esModule?e:{"default":e}}Object.defineProperty(t,"__esModule",{value:!0});var s=n(12);Object.defineProperty(t,"AuthenticationDetails",{enumerable:!0,get:function(){return i(s)["default"]}});var r=n(2);Object.defineProperty(t,"AuthenticationHelper",{enumerable:!0,get:function(){return i(r)["default"]}});var o=n(3);Object.defineProperty(t,"CognitoAccessToken",{enumerable:!0,get:function(){return i(o)["default"]}});var a=n(4);Object.defineProperty(t,"CognitoIdToken",{enumerable:!0,get:function(){return i(a)["default"]}});var u=n(5);Object.defineProperty(t,"CognitoRefreshToken",{enumerable:!0,get:function(){return i(u)["default"]}});var c=n(6);Object.defineProperty(t,"CognitoUser",{enumerable:!0,get:function(){return i(c)["default"]}});var l=n(7);Object.defineProperty(t,"CognitoUserAttribute",{enumerable:!0,get:function(){return i(l)["default"]}});var h=n(13);Object.defineProperty(t,"CognitoUserPool",{enumerable:!0,get:function(){return i(h)["default"]}});var d=n(8);Object.defineProperty(t,"CognitoUserSession",{enumerable:!0,get:function(){return i(d)["default"]}});var f=n(9);Object.defineProperty(t,"DateHelper",{enumerable:!0,get:function(){return i(f)["default"]}})}])});
//# sourceMappingURL=amazon-cognito-identity.min.js.map